/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.ingredients.IngredientSortStage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class IngredientSorterComparators {
    private final IngredientFilter ingredientFilter;
    private final IIngredientManager ingredientManager;
    private final ModNameSortingConfig modNameSortingConfig;
    private final IngredientTypeSortingConfig ingredientTypeSortingConfig;

    public IngredientSorterComparators(IngredientFilter ingredientFilter, IIngredientManager ingredientManager, ModNameSortingConfig modNameSortingConfig, IngredientTypeSortingConfig ingredientTypeSortingConfig) {
        this.ingredientFilter = ingredientFilter;
        this.ingredientManager = ingredientManager;
        this.modNameSortingConfig = modNameSortingConfig;
        this.ingredientTypeSortingConfig = ingredientTypeSortingConfig;
    }

    public Comparator<IIngredientListElementInfo<?>> getComparator(List<IngredientSortStage> ingredientSorterStages) {
        return ingredientSorterStages.stream().map(this::getComparator).reduce(Comparator::thenComparing).orElseGet(this::getDefault);
    }

    public Comparator<IIngredientListElementInfo<?>> getComparator(IngredientSortStage ingredientSortStage) {
        return switch (ingredientSortStage) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientSortStage.ALPHABETICAL -> IngredientSorterComparators.getAlphabeticalComparator();
            case IngredientSortStage.CREATIVE_MENU -> IngredientSorterComparators.getCreativeMenuComparator();
            case IngredientSortStage.INGREDIENT_TYPE -> this.getIngredientTypeComparator();
            case IngredientSortStage.MOD_NAME -> this.getModNameComparator();
            case IngredientSortStage.TOOL_TYPE -> IngredientSorterComparators.getToolsComparator();
            case IngredientSortStage.TAG -> IngredientSorterComparators.getTagComparator();
            case IngredientSortStage.WEAPON_DAMAGE -> IngredientSorterComparators.getWeaponDamageComparator();
            case IngredientSortStage.ARMOR -> IngredientSorterComparators.getArmorComparator();
            case IngredientSortStage.MAX_DURABILITY -> IngredientSorterComparators.getMaxDurabilityComparator();
        };
    }

    public Comparator<IIngredientListElementInfo<?>> getDefault() {
        return this.getModNameComparator().thenComparing(this.getIngredientTypeComparator()).thenComparing(IngredientSorterComparators.getCreativeMenuComparator());
    }

    private static Comparator<IIngredientListElementInfo<?>> getCreativeMenuComparator() {
        return Comparator.comparingInt(o -> {
            IIngredientListElement element = o.getElement();
            return element.getOrderIndex();
        });
    }

    private static Comparator<IIngredientListElementInfo<?>> getAlphabeticalComparator() {
        return Comparator.comparing(IIngredientListElementInfo::getName);
    }

    private Comparator<IIngredientListElementInfo<?>> getModNameComparator() {
        Set<String> modNames = this.ingredientFilter.getModNamesForSorting();
        return this.modNameSortingConfig.getComparatorFromMappedValues(modNames);
    }

    private Comparator<IIngredientListElementInfo<?>> getIngredientTypeComparator() {
        Collection<IIngredientType<?>> ingredientTypes = this.ingredientManager.getRegisteredIngredientTypes();
        Set ingredientTypeStrings = ingredientTypes.stream().map(IIngredientType::getIngredientClass).map(IngredientTypeSortingConfig::getIngredientType).collect(Collectors.toSet());
        return this.ingredientTypeSortingConfig.getComparatorFromMappedValues(ingredientTypeStrings);
    }

    private static Comparator<IIngredientListElementInfo<?>> getMaxDurabilityComparator() {
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getItemStack(o).getMaxDamage());
        return maxDamage.reversed();
    }

    private static Comparator<IIngredientListElementInfo<?>> getTagComparator() {
        Comparator<IIngredientListElementInfo> isTagged = Comparator.comparing(IngredientSorterComparators::hasTag);
        Comparator<IIngredientListElementInfo> tag = Comparator.comparing(IngredientSorterComparators::getTagForSorting);
        return isTagged.reversed().thenComparing(tag);
    }

    private static Comparator<IIngredientListElementInfo<?>> getToolsComparator() {
        Comparator<IIngredientListElementInfo> toolType = Comparator.comparing(o -> IngredientSorterComparators.getToolClass(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> tier = Comparator.comparing(o -> IngredientSorterComparators.getTier(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getToolDurability(IngredientSorterComparators.getItemStack(o)));
        return toolType.reversed().thenComparing(tier.reversed()).thenComparing(maxDamage.reversed());
    }

    private static Comparator<IIngredientListElementInfo<?>> getWeaponDamageComparator() {
        Comparator<IIngredientListElementInfo> isWeaponComp = Comparator.comparing(o -> IngredientSorterComparators.isWeapon(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> attackDamage = Comparator.comparing(o -> IngredientSorterComparators.getWeaponDamage(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> attackSpeed = Comparator.comparing(o -> IngredientSorterComparators.getWeaponSpeed(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getWeaponDurability(IngredientSorterComparators.getItemStack(o)));
        return isWeaponComp.reversed().thenComparing(attackDamage.reversed()).thenComparing(attackSpeed.reversed()).thenComparing(maxDamage.reversed());
    }

    private static Comparator<IIngredientListElementInfo<?>> getArmorComparator() {
        Comparator<IIngredientListElementInfo> isArmorComp = Comparator.comparing(o -> IngredientSorterComparators.isArmor(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> armorSlot = Comparator.comparing(o -> IngredientSorterComparators.getArmorSlotIndex(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> armorDamage = Comparator.comparing(o -> IngredientSorterComparators.getArmorDamageReduce(IngredientSorterComparators.getItemStack(o)));
        Comparator<IIngredientListElementInfo> armorToughness = Comparator.comparing(o -> Float.valueOf(IngredientSorterComparators.getArmorToughness(IngredientSorterComparators.getItemStack(o))));
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getArmorDurability(IngredientSorterComparators.getItemStack(o)));
        return isArmorComp.reversed().thenComparing(armorSlot.reversed()).thenComparing(armorDamage.reversed()).thenComparing(armorToughness.reversed()).thenComparing(maxDamage.reversed());
    }

    private static int getTier(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.getTier();
            List sortedTiers = TierSortingRegistry.getSortedTiers();
            return sortedTiers.indexOf(tier);
        }
        return -1;
    }

    private static boolean isTool(ItemStack itemStack) {
        return IngredientSorterComparators.getToolActions(itemStack).stream().anyMatch(arg_0 -> ((ItemStack)itemStack).canPerformAction(arg_0));
    }

    private static int getToolDurability(ItemStack itemStack) {
        if (!IngredientSorterComparators.isTool(itemStack)) {
            return 0;
        }
        return itemStack.getMaxDamage();
    }

    private static boolean isWeapon(ItemStack itemStack) {
        return IngredientSorterComparators.getWeaponDamage(itemStack) > 0.0;
    }

    private static double getWeaponDamage(ItemStack itemStack) {
        if (IngredientSorterComparators.isTool(itemStack) || IngredientSorterComparators.isArmor(itemStack)) {
            return 0.0;
        }
        Multimap multimap = itemStack.getAttributeModifiers(EquipmentSlot.MAINHAND);
        return IngredientSorterComparators.max((Multimap<Attribute, AttributeModifier>)multimap, Attributes.ATTACK_DAMAGE);
    }

    private static double getWeaponSpeed(ItemStack itemStack) {
        if (!IngredientSorterComparators.isWeapon(itemStack)) {
            return 0.0;
        }
        Multimap multimap = itemStack.getAttributeModifiers(EquipmentSlot.MAINHAND);
        return IngredientSorterComparators.max((Multimap<Attribute, AttributeModifier>)multimap, Attributes.ATTACK_SPEED);
    }

    private static double max(Multimap<Attribute, AttributeModifier> multimap, Attribute attribute) {
        Collection modifiers = multimap.get((Object)attribute);
        return IngredientSorterComparators.max(modifiers);
    }

    private static double max(Collection<AttributeModifier> modifiers) {
        return modifiers.stream().mapToDouble(AttributeModifier::getAmount).max().orElse(0.0);
    }

    private static int getWeaponDurability(ItemStack itemStack) {
        if (IngredientSorterComparators.isWeapon(itemStack)) {
            return itemStack.getMaxDamage();
        }
        return 0;
    }

    private static boolean isArmor(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return item instanceof ArmorItem;
    }

    private static int getArmorSlotIndex(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getSlot().getFilterFlag();
        }
        return 0;
    }

    private static int getArmorDamageReduce(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getDefense();
        }
        return 0;
    }

    private static float getArmorToughness(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getToughness();
        }
        return 0.0f;
    }

    private static int getArmorDurability(ItemStack itemStack) {
        if (IngredientSorterComparators.isArmor(itemStack)) {
            return itemStack.getMaxDamage();
        }
        return 0;
    }

    private static String getTagForSorting(IIngredientListElementInfo<?> elementInfo) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        Collection<ResourceLocation> tagIds = elementInfo.getTagIds(ingredientManager);
        String bestTag = "";
        int maxTagSize = 0;
        for (ResourceLocation tagId : tagIds) {
            int thisTagSize = IngredientSorterComparators.tagCount(tagId);
            if (thisTagSize <= maxTagSize) continue;
            bestTag = tagId.getPath();
            maxTagSize = thisTagSize;
        }
        return bestTag;
    }

    private static int tagCount(ResourceLocation tagId) {
        if (tagId.toString().equals("itemfilters:check_nbt")) {
            return 0;
        }
        TagCollection allTags = ItemTags.getAllTags();
        Tag tags = allTags.getTagOrEmpty(tagId);
        List values = tags.getValues();
        return values.size();
    }

    private static boolean hasTag(IIngredientListElementInfo<?> elementInfo) {
        return !IngredientSorterComparators.getTagForSorting(elementInfo).isEmpty();
    }

    private static String getToolClass(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return "";
        }
        return IngredientSorterComparators.getToolActions(itemStack).stream().filter(arg_0 -> ((ItemStack)itemStack).canPerformAction(arg_0)).findFirst().map(ToolAction::name).orElse("");
    }

    private static Collection<ToolAction> getToolActions(ItemStack itemStack) {
        itemStack.canPerformAction(ToolActions.AXE_DIG);
        return ToolAction.getActions();
    }

    public static <V> ItemStack getItemStack(IIngredientListElementInfo<V> ingredientInfo) {
        IIngredientListElement<V> element = ingredientInfo.getElement();
        V ingredient = element.getIngredient();
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return itemStack;
        }
        return ItemStack.EMPTY;
    }
}

