/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.util.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.TooltipFlag;

public final class IngredientInformation {
    private IngredientInformation() {
    }

    public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String displayName = ingredientHelper.getDisplayName(ingredient);
        return IngredientInformation.removeChatFormatting(displayName);
    }

    public static <T> List<String> getTooltipStrings(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove, IIngredientFilterConfig config) {
        TooltipFlag.Default tooltipFlag = config.getSearchAdvancedTooltips() ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        List<Component> tooltip = ingredientRenderer.getTooltip(ingredient, (TooltipFlag)tooltipFlag);
        return tooltip.stream().map(Component::getString).map(IngredientInformation::removeChatFormatting).map(Translator::toLowercaseWithLocale).map(line -> {
            for (String excludeWord : toRemove) {
                line = line.replace(excludeWord, "");
            }
            return line;
        }).filter(line -> !StringUtil.isNullOrEmpty((String)line)).collect(Collectors.toList());
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.stripFormatting((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    public static <V> Collection<String> getColorStrings(V ingredient, IIngredientHelper<V> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(ingredient);
        ColorNamer colorNamer = Internal.getColorNamer();
        return colorNamer.getColorNames(colors, true);
    }

    public static <V> List<String> getUniqueIdsWithWildcard(IIngredientHelper<V> ingredientHelper, V ingredient, UidContext context) {
        String uidWild;
        String uid = ingredientHelper.getUniqueId(ingredient, context);
        if (uid.equals(uidWild = ingredientHelper.getWildcardId(ingredient))) {
            return Collections.singletonList(uid);
        }
        return Arrays.asList(uid, uidWild);
    }
}

