/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class ShapelessIcon {
    private static final int scale = 4;
    private final IDrawable icon = Internal.getTextures().getShapelessIcon();
    private final HoverChecker hoverChecker;

    public ShapelessIcon() {
        int iconBottom = this.icon.getHeight() / 4;
        int iconLeft = 116 - this.icon.getWidth() / 4;
        int iconRight = iconLeft + this.icon.getWidth() / 4;
        this.hoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight);
    }

    public void draw(PoseStack poseStack, int recipeWidth) {
        int shapelessIconX = recipeWidth - this.icon.getWidth() / 4;
        poseStack.pushPose();
        poseStack.translate((double)shapelessIconX, 0.0, 0.0);
        poseStack.scale(0.25f, 0.25f, 1.0f);
        this.icon.draw(poseStack);
        poseStack.popPose();
    }

    @Nullable
    public List<Component> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(new TranslatableComponent("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

