/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.IOnClickHandler;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.transfer.RecipeTransferUtil;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    private final RecipeLayout<?> recipeLayout;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(int xPos, int yPos, int width, int height, IDrawable icon, RecipeLayout<?> recipeLayout) {
        super(xPos, yPos, width, height, icon, b -> {});
        this.recipeLayout = recipeLayout;
    }

    public void init(RecipeTransferManager recipeTransferManager, @Nullable AbstractContainerMenu container, Player player) {
        this.recipeTransferError = container != null ? RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, this.recipeLayout, player) : RecipeTransferErrorInternal.INSTANCE;
        if (RecipeTransferUtil.allowsTransfer(this.recipeTransferError)) {
            this.active = true;
            this.visible = true;
        } else {
            this.active = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.visible = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    public void drawToolTip(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.recipeTransferError == null) {
                TranslatableComponent tooltipTransfer = new TranslatableComponent("jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText(poseStack, List.of(tooltipTransfer), mouseX, mouseY);
            } else {
                this.recipeTransferError.showError(poseStack, mouseX, mouseY, this.recipeLayout, this.recipeLayout.getPosX(), this.recipeLayout.getPosY());
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.render(poseStack, mouseX, mouseY, partialTicks);
        if (this.visible && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
            RecipeTransferButton.fill((PoseStack)poseStack, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-2130729728);
        }
    }

    public void setOnClickHandler(IOnClickHandler onClickHandler) {
        this.onClickHandler = onClickHandler;
    }

    public void onRelease(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

