/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory<?> category;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, int x, int y) {
        super(x, y);
        this.logic = logic;
        this.category = category;
    }

    @Override
    public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
        if (!this.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return null;
        }
        if (!input.isSimulate()) {
            this.logic.setRecipeCategory(this.category);
            SoundManager soundHandler = Minecraft.getInstance().getSoundManager();
            soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        return this;
    }

    @Override
    public void draw(boolean selected, PoseStack poseStack, int mouseX, int mouseY) {
        super.draw(selected, poseStack, mouseX, mouseY);
        int iconX = this.x + 4;
        int iconY = this.y + 4;
        IDrawable icon = this.category.getIcon();
        if (icon != null) {
            icon.draw(poseStack, iconX += (16 - icon.getWidth()) / 2, iconY += (16 - icon.getHeight()) / 2);
        } else {
            List<Object> recipeCatalysts = this.logic.getRecipeCatalysts(this.category);
            if (!recipeCatalysts.isEmpty()) {
                Object ingredient = recipeCatalysts.get(0);
                RecipeCategoryTab.renderIngredient(poseStack, iconX, iconY, ingredient);
            } else {
                String text = this.category.getTitle().getString().substring(0, 2);
                Minecraft minecraft = Minecraft.getInstance();
                Font fontRenderer = minecraft.font;
                int textCenterX = this.x + 12;
                int textCenterY = this.y + 12 - 3;
                int color = this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
                int stringCenter = fontRenderer.width(text) / 2;
                fontRenderer.drawShadow(poseStack, text, (float)(textCenterX - stringCenter), (float)textCenterY, color);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static <T> void renderIngredient(PoseStack poseStack, int iconX, int iconY, T ingredient) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredient);
        RenderSystem.enableDepthTest();
        ingredientRenderer.render(poseStack, iconX, iconY, ingredient);
        RenderSystem.disableDepthTest();
    }

    @Override
    public boolean isSelected(IRecipeCategory<?> selectedCategory) {
        return this.category.getUid().equals((Object)selectedCategory.getUid());
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Component title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        ResourceLocation uid = this.category.getUid();
        String modId = uid.getNamespace();
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add((Component)new TextComponent(modName));
        }
        return tooltip;
    }
}

