/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.textures.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;

public class GuiIconButtonSmall
extends Button {
    private final IDrawable icon;

    public GuiIconButtonSmall(int x, int y, int widthIn, int heightIn, IDrawable icon, Button.OnPress pressable) {
        super(x, y, widthIn, heightIn, TextComponent.EMPTY, pressable);
        this.icon = icon;
    }

    public Rect2i getArea() {
        return new Rect2i(this.x, this.y, this.width, this.height);
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft minecraft = Minecraft.getInstance();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean hovered = this.isMouseOver(mouseX, mouseY);
            Textures textures = Internal.getTextures();
            DrawableNineSliceTexture texture = textures.getButtonForState(this.active, hovered);
            texture.draw(poseStack, this.x, this.y, this.width, this.height);
            this.renderBg(poseStack, minecraft, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            } else if (!this.active) {
                color = 0xA0A0A0;
            } else if (hovered) {
                color = 0xFFFFA0;
            }
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)blue, (float)green, (float)alpha);
            double xOffset = (double)this.x + (double)(this.width - this.icon.getWidth()) / 2.0;
            double yOffset = (double)this.y + (double)(this.height - this.icon.getHeight()) / 2.0;
            poseStack.pushPose();
            poseStack.translate(xOffset, yOffset, 0.0);
            this.icon.draw(poseStack);
            poseStack.popPose();
        }
    }
}

