/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;

public class GuiIconButton
extends Button {
    private final IDrawable icon;

    public GuiIconButton(IDrawable icon, Button.OnPress pressable) {
        super(0, 0, 0, 0, TextComponent.EMPTY, pressable);
        this.icon = icon;
    }

    public void updateBounds(Rect2i area) {
        this.x = area.getX();
        this.y = area.getY();
        this.width = area.getWidth();
        this.height = area.getHeight();
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Textures textures = Internal.getTextures();
            Minecraft minecraft = Minecraft.getInstance();
            DrawableNineSliceTexture texture = textures.getButtonForState(this.active, hovered);
            texture.draw(poseStack, this.x, this.y, this.width, this.height);
            this.renderBg(poseStack, minecraft, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            } else if (!this.active) {
                color = 0xA0A0A0;
            } else if (hovered) {
                color = 0xFFFFA0;
            }
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)blue, (float)green, (float)alpha);
            double xOffset = (double)this.x + (double)(this.width - this.icon.getWidth()) / 2.0;
            double yOffset = (double)this.y + (double)(this.height - this.icon.getHeight()) / 2.0;
            poseStack.pushPose();
            poseStack.translate(xOffset, yOffset, 0.0);
            this.icon.draw(poseStack);
            poseStack.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler(this);
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private final GuiIconButton button;

        public UserInputHandler(GuiIconButton button) {
            this.button = button;
        }

        @Override
        public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
            if (!input.isMouse()) {
                return null;
            }
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            if (!(this.button.active && this.button.visible && GuiIconButton.this.isMouseOver(mouseX, mouseY))) {
                return null;
            }
            if (!this.button.isValidClickButton(input.getKey().getValue())) {
                return null;
            }
            boolean flag = this.button.clicked(mouseX, mouseY);
            if (!flag) {
                return null;
            }
            if (!input.isSimulate()) {
                this.button.playDownSound(Minecraft.getInstance().getSoundManager());
                this.button.onClick(mouseX, mouseY);
            }
            return this;
        }
    }
}

