/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.config.Constants;
import mezz.jei.gui.textures.JeiSpriteUploader;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class DrawableSprite
implements IDrawableStatic {
    private final JeiSpriteUploader spriteUploader;
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private int trimLeft;
    private int trimRight;
    private int trimTop;
    private int trimBottom;

    public DrawableSprite(JeiSpriteUploader spriteUploader, ResourceLocation location, int width, int height) {
        this.spriteUploader = spriteUploader;
        this.location = location;
        this.width = width;
        this.height = height;
    }

    public DrawableSprite trim(int left, int right, int top, int bottom) {
        this.trimLeft = left;
        this.trimRight = right;
        this.trimTop = top;
        this.trimBottom = bottom;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        this.draw(poseStack, xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(PoseStack poseStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        TextureAtlasSprite sprite = this.spriteUploader.getSprite(this.location);
        int textureWidth = this.width;
        int textureHeight = this.height;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);
        int x = xOffset + (maskLeft += this.trimLeft);
        int y = yOffset + (maskTop += this.trimTop);
        int width = textureWidth - (maskRight += this.trimRight) - maskLeft;
        int height = textureHeight - (maskBottom += this.trimBottom) - maskTop;
        float uSize = sprite.getU1() - sprite.getU0();
        float vSize = sprite.getV1() - sprite.getV0();
        float minU = sprite.getU0() + uSize * ((float)maskLeft / (float)textureWidth);
        float minV = sprite.getV0() + vSize * ((float)maskTop / (float)textureHeight);
        float maxU = sprite.getU1() - uSize * ((float)maskRight / (float)textureWidth);
        float maxV = sprite.getV1() - vSize * ((float)maskBottom / (float)textureHeight);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = poseStack.last().pose();
        bufferBuilder.vertex(matrix, (float)x, (float)(y + height), 0.0f).uv(minU, maxV).endVertex();
        bufferBuilder.vertex(matrix, (float)(x + width), (float)(y + height), 0.0f).uv(maxU, maxV).endVertex();
        bufferBuilder.vertex(matrix, (float)(x + width), (float)y, 0.0f).uv(maxU, minV).endVertex();
        bufferBuilder.vertex(matrix, (float)x, (float)y, 0.0f).uv(minU, minV).endVertex();
        tessellator.end();
    }
}

