/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class ServerInfo {
    private static boolean jeiOnServer = false;
    private static final Path worldDirPath = Path.of("world", new String[0]);
    private static final String unsafeFileChars = "[^\\w-]";

    private ServerInfo() {
    }

    public static boolean isJeiOnServer() {
        return jeiOnServer;
    }

    public static void onConnectedToServer(boolean jeiOnServer) {
        ServerInfo.jeiOnServer = jeiOnServer;
    }

    @Nullable
    public static Path getWorldPath(Path basePath) {
        Path worldPath = ServerInfo.getWorldPath();
        if (worldPath == null) {
            return null;
        }
        return basePath.resolve(worldPath);
    }

    @Nullable
    private static Path getWorldPath() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null) {
            return null;
        }
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        if (clientPacketListener == null) {
            return null;
        }
        Connection connection = clientPacketListener.getConnection();
        if (connection == null) {
            return null;
        }
        if (connection.isMemoryConnection()) {
            MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
            if (minecraftServer != null) {
                String name = minecraftServer.storageSource.getLevelId();
                name = ServerInfo.sanitizePathName(name);
                return worldDirPath.resolve("local").resolve(name);
            }
        } else {
            ServerData serverData = minecraft.getCurrentServer();
            if (serverData != null) {
                int ipHash = serverData.ip.hashCode();
                String ipHashHex = Integer.toHexString(ipHash);
                String name = String.format("%s_%s", serverData.name, ipHashHex);
                name = ServerInfo.sanitizePathName(name);
                return worldDirPath.resolve("server").resolve(name);
            }
        }
        return null;
    }

    public static String sanitizePathName(String filename) {
        return String.join((CharSequence)"_", filename.split(unsafeFileChars));
    }
}

