/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import mezz.jei.config.IJEIConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModIdFormattingConfig
implements IJEIConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    public static final String defaultModNameFormatFriendly = "blue italic";
    private String modNameFormatFriendly = "blue italic";
    public String modNameFormat = ModIdFormattingConfig.parseFriendlyModNameFormat("blue italic");
    @Nullable
    private String modNameFormatOverride;
    public final ForgeConfigSpec.ConfigValue<String> modNameFormatConfig;

    public ModIdFormattingConfig(ForgeConfigSpec.Builder builder) {
        EnumSet<ChatFormatting> validFormatting = EnumSet.allOf(ChatFormatting.class);
        validFormatting.remove(ChatFormatting.RESET);
        StringJoiner validColorsJoiner = new StringJoiner(", ");
        StringJoiner validFormatsJoiner = new StringJoiner(", ");
        for (ChatFormatting chatFormatting : validFormatting) {
            String lowerCaseName = chatFormatting.getName().toLowerCase(Locale.ENGLISH);
            if (chatFormatting.isColor()) {
                validColorsJoiner.add(lowerCaseName);
                continue;
            }
            if (!chatFormatting.isFormat()) continue;
            validFormatsJoiner.add(lowerCaseName);
        }
        String validColors = validColorsJoiner.toString();
        String validFormats = validFormatsJoiner.toString();
        builder.push("modname");
        builder.comment(new String[]{"Formatting for mod name tooltip", "Use these formatting colors:", validColors, "With these formatting options:", validFormats});
        this.modNameFormatConfig = builder.define("ModNameFormat", (Object)defaultModNameFormatFriendly);
        builder.pop();
    }

    @Override
    public void reload() {
        this.modNameFormatFriendly = (String)this.modNameFormatConfig.get();
        this.updateModNameFormat();
    }

    public String getModNameFormat() {
        String override = this.modNameFormatOverride;
        if (override != null) {
            return override;
        }
        return this.modNameFormat;
    }

    public boolean isModNameFormatOverrideActive() {
        return this.modNameFormatOverride != null;
    }

    public void checkForModNameFormatOverride() {
        String modNameFormatOverride = ModIdFormattingConfig.detectModNameTooltipFormatting();
        if (!Objects.equals(this.modNameFormatOverride, modNameFormatOverride)) {
            this.modNameFormatOverride = modNameFormatOverride;
            this.updateModNameFormat();
        }
    }

    private void updateModNameFormat() {
        this.modNameFormat = ModIdFormattingConfig.parseFriendlyModNameFormat(this.modNameFormatFriendly);
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            ChatFormatting valueByName = ChatFormatting.getByName((String)string);
            if (valueByName != null) {
                format.append(valueByName);
                continue;
            }
            LOGGER.error("Invalid format: {}", (Object)string);
        }
        return format.toString();
    }

    @Nullable
    private static String detectModNameTooltipFormatting() {
        try {
            ItemStack itemStack = new ItemStack((ItemLike)Items.APPLE);
            Minecraft minecraft = Minecraft.getInstance();
            assert (minecraft != null);
            LocalPlayer player = minecraft.player;
            List tooltip = new ArrayList<TextComponent>();
            tooltip.add(new TextComponent("JEI Tooltip Testing for mod name formatting"));
            ItemTooltipEvent tooltipEvent = ForgeEventFactory.onItemTooltip((ItemStack)itemStack, (Player)player, tooltip, (TooltipFlag)TooltipFlag.Default.NORMAL);
            tooltip = tooltipEvent.getToolTip();
            if (tooltip.size() > 1) {
                for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
                    String withoutFormatting;
                    Component line = (Component)tooltip.get(lineNum);
                    String lineString = line.getString();
                    if (!lineString.contains("Minecraft") || (withoutFormatting = ChatFormatting.stripFormatting((String)lineString)) == null) continue;
                    if (lineString.equals(withoutFormatting)) {
                        return "";
                    }
                    if (!lineString.contains(withoutFormatting)) continue;
                    return StringUtils.replaceOnce((String)lineString, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
                }
            }
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error while Testing for mod name formatting", e);
        }
        return null;
    }
}

