/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.ServerConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.gui.textures.JeiSpriteUploader;
import mezz.jei.gui.textures.Textures;
import mezz.jei.startup.ClientLifecycleHandler;
import mezz.jei.startup.JeiReloadListener;
import mezz.jei.startup.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="jei")
public class JustEnoughItems {
    public JustEnoughItems() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        NetworkHandler networkHandler = new NetworkHandler();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> JustEnoughItems.clientStart(modEventBus, networkHandler));
        JustEnoughItems.commonStart(modEventBus, networkHandler);
    }

    private static void clientStart(IEventBus modEventBus, NetworkHandler networkHandler) {
        JEIClientConfig.register(modEventBus);
        EventBusHelper.addListener(JustEnoughItems.class, modEventBus, RegisterClientReloadListenersEvent.class, registerReloadListenerEvent -> {
            Minecraft minecraft = Minecraft.getInstance();
            JeiSpriteUploader spriteUploader = new JeiSpriteUploader(minecraft.textureManager);
            Textures textures = new Textures(spriteUploader);
            registerReloadListenerEvent.registerReloadListener((PreparableReloadListener)spriteUploader);
            JeiReloadListener.initializeJeiReloadListener(registerReloadListenerEvent);
            EventBusHelper.addLifecycleListener(JustEnoughItems.class, modEventBus, FMLLoadCompleteEvent.class, loadCompleteEvent -> new ClientLifecycleHandler(networkHandler, textures));
        });
    }

    private static void commonStart(IEventBus modEventBus, NetworkHandler networkHandler) {
        EventBusHelper.addLifecycleListener(JustEnoughItems.class, modEventBus, FMLCommonSetupEvent.class, event -> {
            networkHandler.createServerPacketHandler();
            ModLoadingContext modLoadingContext = ModLoadingContext.get();
            ServerConfig.register(modEventBus, modLoadingContext);
        });
    }
}

