/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.model;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.util.UIState;

public class TextProperties {
    protected Set<Context.UI> activeUIs = new HashSet<Context.UI>(Arrays.asList(Context.UI.all()));
    protected Set<Context.MapType> activeMapTypes = new HashSet<Context.MapType>(Arrays.asList(Context.MapType.all()));
    protected float scale = 1.0f;
    protected int color = 0xFFFFFF;
    protected int backgroundColor = 0;
    protected float opacity = 1.0f;
    protected float backgroundOpacity = 0.5f;
    protected boolean fontShadow = true;
    protected int minZoom = 2;
    protected int maxZoom = 16384;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public float getScale() {
        return this.scale;
    }

    public TextProperties setScale(float scale) {
        this.scale = Math.max(1.0f, Math.min(scale, 8.0f));
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public TextProperties setColor(int color) {
        this.color = Displayable.clampRGB(color);
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public TextProperties setBackgroundColor(int backgroundColor) {
        this.backgroundColor = Displayable.clampRGB(backgroundColor);
        return this;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public TextProperties setOpacity(float opacity) {
        this.opacity = Displayable.clampOpacity(opacity);
        return this;
    }

    public float getBackgroundOpacity() {
        return this.backgroundOpacity;
    }

    public TextProperties setBackgroundOpacity(float backgroundOpacity) {
        this.backgroundOpacity = Displayable.clampOpacity(backgroundOpacity);
        return this;
    }

    public boolean hasFontShadow() {
        return this.fontShadow;
    }

    public TextProperties setFontShadow(boolean fontShadow) {
        this.fontShadow = fontShadow;
        return this;
    }

    public Set<Context.UI> getActiveUIs() {
        return this.activeUIs;
    }

    public TextProperties setActiveUIs(Context.UI ... activeUIs) {
        this.activeUIs = new HashSet<Context.UI>();
        this.activeUIs.addAll(Arrays.asList(activeUIs));
        return this;
    }

    public Set<Context.MapType> getActiveMapTypes() {
        return this.activeMapTypes;
    }

    public TextProperties setActiveMapTypes(Context.MapType ... activeMapTypes) {
        this.activeMapTypes = new HashSet<Context.MapType>();
        this.activeMapTypes.addAll(Arrays.asList(activeMapTypes));
        return this;
    }

    public boolean isActiveIn(UIState uiState) {
        return uiState.active && this.activeUIs.contains(uiState.ui) && this.activeMapTypes.contains(uiState.mapType) && this.minZoom <= uiState.zoom && this.maxZoom >= uiState.zoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public TextProperties setMinZoom(int minZoom) {
        this.minZoom = Math.max(2, minZoom);
        return this;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public TextProperties setMaxZoom(int maxZoom) {
        this.maxZoom = Math.min(16384, maxZoom);
        return this;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public TextProperties setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public TextProperties setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("activeMapTypes", this.activeMapTypes).add("activeUIs", this.activeUIs).add("backgroundColor", this.backgroundColor).add("backgroundOpacity", this.backgroundOpacity).add("color", this.color).add("opacity", this.opacity).add("fontShadow", this.fontShadow).add("maxZoom", this.maxZoom).add("minZoom", this.minZoom).add("offsetX", this.offsetX).add("offsetY", this.offsetY).add("scale", this.scale).toString();
    }
}

