package journeymap.api.v2.client.fullscreen;

import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface ThemeButtonDisplay
{
    /**
     * Creates and adds a theme toggle button with a separate on/off label to the toolbar.
     *
     * @param labelOn  - The on label, can be the display string or i18n key.
     * @param labelOff - The off label, can be the display string or i18n key.
     * @param icon - The icon name. Icon Identifier
     * @param toggled  - If button starts toggled.
     * @param onPress  - The onpress action.
     * @return IThemeButton
     */
    IThemeButton addThemeToggleButton(@NotNull String labelOn, @NotNull String labelOff, @NotNull class_2960 icon, boolean toggled, @NotNull IThemeButton.Action onPress);

    /**
     * Creates and adds a theme button with a separate on/off label to the toolbar.
     *
     * @param labelOn  - The on label, can be the display string or i18n key.
     * @param labelOff - The off label, can be the display string or i18n key.
     * @param icon - The icon name. Icon Identifier
     * @param onPress  - The onpress action.
     * @return IThemeButton
     */
    IThemeButton addThemeButton(@NotNull String labelOn, @NotNull String labelOff, @NotNull class_2960 icon, @NotNull IThemeButton.Action onPress);

    /**
     * Creates and adds a theme toggle button with a separate on/off label to the toolbar.
     *
     * @param label    - The label, can be the display string or i18n key.
     * @param icon - The icon name. Icon Identifier
     * @param toggled  - If button starts toggled.
     * @param onPress  - The onpress action.
     * @return IThemeButton
     */
    IThemeButton addThemeToggleButton(@NotNull String label, @NotNull class_2960 icon, boolean toggled, @NotNull IThemeButton.Action onPress);

    /**
     * Creates and adds a theme button with a separate on/off label to the toolbar.
     *
     * @param label    - The label, can be the display string or i18n key.
     * @param icon - The icon name. Icon Identifier
     * @param onPress  - The onpress action.
     * @return IThemeButton
     */
    IThemeButton addThemeButton(@NotNull String label, @NotNull class_2960 icon, @NotNull IThemeButton.Action onPress);

}
