package journeymap.api.v2.common.event.common;

import journeymap.api.v2.common.event.impl.CommonEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import javax.annotation.Nullable;

public class TeleportEvent extends CommonEvent
{
    @Nullable
    private final Waypoint waypoint;
    private class_2338 pos;
    private final class_5321<class_1937> fromLevel;
    private class_5321<class_1937> destinationLevel;

    public TeleportEvent(@Nullable Waypoint waypoint, class_2338 pos, class_5321<class_1937> fromLevel, class_5321<class_1937> destinationLevel)
    {
        // Currently only supported on the client. Will eventually support being on the server.
        super(true, Side.Client);
        this.waypoint = waypoint;
        this.pos = pos;
        this.fromLevel = fromLevel;
        this.destinationLevel = destinationLevel;
    }

    public TeleportEvent(class_2338 pos, class_5321<class_1937> level)
    {
        this(null, pos, level, level);
    }

    /**
     * This will be null for context menu teleporting on the fullscreen map.
     * <p>
     * Do not modify this, use only for information.
     *
     * @return - The Waypoint
     */
    @Nullable
    public Waypoint getWaypoint()
    {
        return waypoint;
    }

    /**
     * Block Position of target location.
     *
     * @return the blockpos
     */
    public class_2338 getPos()
    {
        return pos;
    }

    /**
     * Update this to modify final teleport location
     *
     * @param pos
     */
    public void setPos(class_2338 pos)
    {
        this.pos = pos;
    }

    /**
     * Dimension where the user initiated the teleport.
     *
     * @return - the level key.
     */
    public class_5321<class_1937> getFromLevel()
    {
        return fromLevel;
    }

    /**
     * Destination Dimension
     *
     * @return - the destination dimension.
     */
    public class_5321<class_1937> getDestinationLevel()
    {
        return destinationLevel;
    }

    /**
     * Set to override the destination level.
     *
     * @param destinationLevel
     */
    public void setDestinationLevel(class_5321<class_1937> destinationLevel)
    {
        this.destinationLevel = destinationLevel;
    }
}
