/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.display;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.IOverlayListener;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
public abstract class Overlay
extends Displayable {
    protected String overlayGroupName;
    protected String title;
    protected String label;
    protected class_5321<class_1937> dimension;
    protected int minZoom = 2;
    protected int maxZoom = 16384;
    protected int displayOrder;
    protected Set<Context.UI> activeUIs = new HashSet<Context.UI>(Arrays.asList(Context.UI.all()));
    protected Set<Context.MapType> activeMapTypes = new HashSet<Context.MapType>(Arrays.asList(Context.MapType.all()));
    protected TextProperties textProperties = new TextProperties();
    protected IOverlayListener overlayListener;
    protected boolean needsRerender = true;

    Overlay(String modId) {
        super(modId);
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public Overlay setDimension(class_5321<class_1937> dimension) {
        this.dimension = dimension;
        return this;
    }

    public String getOverlayGroupName() {
        return this.overlayGroupName;
    }

    public Overlay setOverlayGroupName(String overlayGroupName) {
        this.overlayGroupName = overlayGroupName;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Overlay setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Overlay setLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public Overlay setMinZoom(int minZoom) {
        this.minZoom = Math.max(2, minZoom);
        return this;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public Overlay setMaxZoom(int maxZoom) {
        this.maxZoom = Math.min(16384, maxZoom);
        return this;
    }

    @Override
    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public Overlay setDisplayOrder(int zIndex) {
        this.displayOrder = zIndex;
        return this;
    }

    public TextProperties getTextProperties() {
        return this.textProperties;
    }

    public Overlay setTextProperties(TextProperties textProperties) {
        this.textProperties = textProperties;
        return this;
    }

    public Set<Context.UI> getActiveUIs() {
        return this.activeUIs;
    }

    public Overlay setActiveUIs(Context.UI ... activeUIs) {
        this.activeUIs = new HashSet<Context.UI>();
        this.textProperties.setActiveUIs(activeUIs);
        this.activeUIs.addAll(Arrays.asList(activeUIs));
        return this;
    }

    public Set<Context.MapType> getActiveMapTypes() {
        return this.activeMapTypes;
    }

    public Overlay setActiveMapTypes(Context.MapType ... activeMapTypes) {
        this.activeMapTypes = new HashSet<Context.MapType>();
        this.textProperties.setActiveMapTypes(activeMapTypes);
        this.activeMapTypes.addAll(Arrays.asList(activeMapTypes));
        return this;
    }

    public boolean isActiveIn(UIState uiState) {
        return uiState.active && this.dimension == uiState.dimension && this.activeUIs.contains(uiState.ui) && this.activeMapTypes.contains(uiState.mapType);
    }

    public boolean isInZoomRange(UIState uiState) {
        return this.minZoom <= uiState.zoom && this.maxZoom >= uiState.zoom;
    }

    public IOverlayListener getOverlayListener() {
        return this.overlayListener;
    }

    public Overlay setOverlayListener(@Nullable IOverlayListener overlayListener) {
        this.overlayListener = overlayListener;
        return this;
    }

    public void flagForRerender() {
        this.needsRerender = true;
    }

    public void clearFlagForRerender() {
        this.needsRerender = false;
    }

    public boolean getNeedsRerender() {
        return this.needsRerender;
    }

    protected final MoreObjects.ToStringHelper toStringHelper(Overlay instance) {
        return MoreObjects.toStringHelper((Object)this).add("label", (Object)this.label).add("title", (Object)this.title).add("overlayGroupName", (Object)this.overlayGroupName).add("activeMapTypes", this.activeMapTypes).add("activeUIs", this.activeUIs).add("dimension", this.dimension).add("displayOrder", this.displayOrder).add("maxZoom", this.maxZoom).add("minZoom", this.minZoom).add("textProperties", (Object)this.textProperties).add("hasOverlayListener", this.overlayListener != null);
    }
}

