/*
 * JourneyMap API (http://journeymap.info)
 * http://github.com/TeamJM/journeymap-api
 *
 * Copyright (c) 2011-2016 Techbrew.  All Rights Reserved.
 * The following limited rights are granted to you:
 *
 * You MAY:
 *  + Write your own code that uses the API source code in journeymap.* packages as a dependency.
 *  + Write and distribute your own code that uses, modifies, or extends the example source code in example.* packages
 *  + Fork and modify any source code for the purpose of submitting Pull Requests to the TeamJM/journeymap-api repository.
 *    Submitting new or modified code to the repository means that you are granting Techbrew all rights to the submitted code.
 *
 * You MAY NOT:
 *  - Distribute source code or classes (whether modified or not) from journeymap.* packages.
 *  - Submit any code to the TeamJM/journeymap-api repository with a different license than this one.
 *  - Use code or artifacts from the repository in any way not explicitly granted by this license.
 *
 */

package journeymap.api.v2.client.display;

import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.model.MapImage;
import net.minecraft.class_2338;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * An image overlay places an image on the map between the given coordinates.
 * <p>
 * Setters use the Builder pattern so they can be chained.
 * <p>
 * Note that like all Displayables, simply changing this object doesn't guarantee the player will get the changes.
 * You must call {@link IClientAPI#show(Displayable)} in order for the changes to take effect
 * in JourneyMap.
 */
@ParametersAreNonnullByDefault
public final class ImageOverlay extends Overlay
{
    private class_2338 northWestPoint;
    private class_2338 southEastPoint;
    private MapImage image;

    /**
     * Constructor.
     *
     * @param modId          Your mod id.
     * @param northWestPoint Location of the top-left corner of the image.
     * @param southEastPoint Location of the lower-right corner of the image.
     * @param image          The image to display as the overlay.
     */
    public ImageOverlay(String modId,  class_2338 northWestPoint, class_2338 southEastPoint, MapImage image)
    {
        super(modId);
        setNorthWestPoint(northWestPoint);
        setSouthEastPoint(southEastPoint);
        setImage(image);
    }

    /**
     * Top-left location of the image overlay.
     */
    public class_2338 getNorthWestPoint()
    {
        return northWestPoint;
    }

    /**
     * Sets top-left location of the image overlay.
     *
     * @param northWestPoint point
     * @return this
     */
    public ImageOverlay setNorthWestPoint(class_2338 northWestPoint)
    {
        this.northWestPoint = northWestPoint;
        return this;
    }

    /**
     * Bottom-right location of the image overlay.
     */
    public class_2338 getSouthEastPoint()
    {
        return southEastPoint;
    }

    /**
     * Sets bottom-right location of the image overlay.
     *
     * @param southEastPoint point
     * @return this
     */
    public ImageOverlay setSouthEastPoint(class_2338 southEastPoint)
    {
        this.southEastPoint = southEastPoint;
        return this;
    }

    /**
     * Image to display as the overlay.
     *
     * @return icon
     */
    public MapImage getImage()
    {
        return image;
    }

    /**
     * Sets image to display as the overlay.
     *
     * @param image image
     * @return this
     */
    public ImageOverlay setImage(MapImage image)
    {
        this.image = image;
        return this;
    }

    @Override
    public String toString()
    {
        return toStringHelper(this)
                .add("image", image)
                .add("northWestPoint", northWestPoint)
                .add("southEastPoint", southEastPoint)
                .toString();
    }
}
