/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.common.event.common;

import journeymap.api.v2.common.event.impl.JourneyMapEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;

public class WaypointGroupEvent
extends JourneyMapEvent {
    private final WaypointGroup group;
    private final Context context;
    private final boolean deleteWaypoints;

    public WaypointGroupEvent(WaypointGroup group, Context context) {
        this(group, context, false);
    }

    public WaypointGroupEvent(WaypointGroup group, Context context, boolean deleteWaypoints) {
        super(context.cancelable);
        this.group = group;
        this.context = context;
        this.deleteWaypoints = deleteWaypoints;
    }

    public boolean deleteWaypoints() {
        if (Context.DELETED == this.context) {
            return this.deleteWaypoints;
        }
        throw new UnsupportedOperationException("deleteWaypoint can only be called on context DELETED!");
    }

    public WaypointGroup getGroup() {
        return this.group;
    }

    public Context getContext() {
        return this.context;
    }

    public static enum Context {
        CREATE(true),
        UPDATE(true),
        DELETED(false),
        READ(false);

        final boolean cancelable;

        private Context(boolean cancelable) {
            this.cancelable = cancelable;
        }
    }
}

