/*
 * Decompiled with CFR 0.152.
 */
package gay.object.hexdebug.core.api.debugging.env;

import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.ResolvedPatternType;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import gay.object.hexdebug.core.api.HexDebugCoreAPI;
import gay.object.hexdebug.core.api.debugging.DebugStepType;
import gay.object.hexdebug.core.api.debugging.OutputCategory;
import gay.object.hexdebug.core.api.debugging.StopReason;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugEnvironment {
    @NotNull
    private final ServerPlayer caster;
    @NotNull
    private final UUID sessionId = UUID.randomUUID();
    @Nullable
    private DebugStepType lastDebugStepType = null;
    @Nullable
    private Action lastEvaluatedAction = null;

    protected DebugEnvironment(@NotNull ServerPlayer caster) {
        this.caster = caster;
    }

    public abstract boolean resume(@NotNull CastingEnvironment var1, @NotNull CastingImage var2, @NotNull ResolvedPatternType var3);

    public abstract void restart(int var1);

    public abstract void terminate();

    @Contract(pure=true)
    public abstract boolean isCasterInRange();

    @Contract(pure=true)
    @NotNull
    public abstract Component getName();

    public void postStep(@NotNull CastingEnvironment env, @NotNull CastingImage image, @Nullable StopReason reason) {
    }

    public void printDebugMessage(@NotNull Component message) {
        this.printDebugMessage(message, OutputCategory.STDOUT, true);
    }

    public void printDebugMessage(@NotNull Component message, @NotNull OutputCategory category) {
        this.printDebugMessage(message, category, true);
    }

    public void printDebugMessage(@NotNull Component message, @NotNull OutputCategory category, boolean withSource) {
        HexDebugCoreAPI.INSTANCE.printDebugMessage(this.caster, this.sessionId, message, category, withSource);
    }

    public void printDebugMishap(@NotNull CastingEnvironment env, @NotNull OperatorSideEffect.DoMishap sideEffect) {
        Component message = sideEffect.getMishap().errorMessageWithName(env, sideEffect.getErrorCtx());
        if (message != null) {
            this.printDebugMessage(message, OutputCategory.STDERR);
        }
    }

    @Contract(pure=true)
    public boolean isDebugging() {
        return HexDebugCoreAPI.INSTANCE.isSessionDebugging(this);
    }

    @NotNull
    public ServerPlayer getCaster() {
        return this.caster;
    }

    @NotNull
    public UUID getSessionId() {
        return this.sessionId;
    }

    @ApiStatus.Internal
    @Nullable
    public DebugStepType getLastDebugStepType() {
        return this.lastDebugStepType;
    }

    @ApiStatus.Internal
    public void setLastDebugStepType(@Nullable DebugStepType lastDebugStepType) {
        this.lastDebugStepType = lastDebugStepType;
    }

    @ApiStatus.Internal
    @Nullable
    public Action getLastEvaluatedAction() {
        return this.lastEvaluatedAction;
    }

    @ApiStatus.Internal
    public void setLastEvaluatedAction(@Nullable Action lastEvaluatedAction) {
        this.lastEvaluatedAction = lastEvaluatedAction;
    }
}

