package gay.object.hexdebug.core.api.debugging;

import net.minecraft.class_1269;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

/**
 * An interface for a {@link class_2248} or {@link class_2586} that can start debugging when
 * right-clicked by a debugger.
 */
public interface DebuggableBlock {
    /**
     * Called server-side by {@code DebuggerItem#useOn} to start a debug session for this block on
     * the given thread.
     * <br>
     * By default, this just calls {@link DebuggableBlock#startDebugging(class_3222, int)}.
     */
    @NotNull
    default class_1269 startDebugging(@NotNull class_1838 context, int threadId) {
        return startDebugging((class_3222) context.method_8036(), threadId);
    }

    /**
     * Called server-side by the default implementation of
     * {@link DebuggableBlock#startDebugging(class_1838, int)} to start a debug session for this
     * block on the given thread.
     */
    @NotNull
    class_1269 startDebugging(@NotNull class_3222 caster, int threadId);
}
