package gay.object.hexdebug.mixin;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import gay.object.hexdebug.core.api.HexDebugCoreAPI;
import gay.object.hexdebug.core.api.debugging.DebugOutputCategory;
import gay.object.hexdebug.core.api.exceptions.DebugException;
import gay.object.hexdebug.debugger.circles.CircleDebugEnv;
import gay.object.hexdebug.debugger.circles.IMixinBlockEntityAbstractImpetus;
import gay.object.hexdebug.debugger.circles.IMixinCircleExecutionState;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(BlockEntityAbstractImpetus.class)
public abstract class MixinBlockEntityAbstractImpetus
    extends HexBlockEntity implements IMixinBlockEntityAbstractImpetus
{
    @Shadow(remap = false)
    @Nullable
    protected CircleExecutionState executionState;

    public MixinBlockEntityAbstractImpetus(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Shadow
    public abstract void startExecution(@Nullable class_3222 player);

    @SuppressWarnings("AddedMixinMembersNamePattern")
    @Override
    @NotNull
    public class_1269 startDebugging(@NotNull class_3222 caster, int threadId) {
        if (executionState != null) return class_1269.field_5811;

        var debugEnv = new CircleDebugEnv(caster, method_11016());
        try {
            HexDebugCoreAPI.INSTANCE.createDebugThread(debugEnv, threadId);
        } catch (DebugException ignored) {
            return class_1269.field_5811;
        }

        startExecution(caster);
        ((IMixinCircleExecutionState) executionState).setDebugEnv$hexdebug(debugEnv);

        return class_1269.field_21466;
    }

    @Override
    public void hexdebug$clearExecutionState() {
        executionState = null;
    }

    @Inject(method = "postPrint", at = @At("HEAD"))
    private void hexdebug$printDebugMessage(class_2561 printDisplay, CallbackInfo ci) {
        if (executionState != null) {
            var debugEnv = ((IMixinCircleExecutionState) executionState).getDebugEnv$hexdebug();
            if (debugEnv != null) {
                debugEnv.printDebugMessage(printDisplay);
            }
        }
    }

    @Inject(method = "postMishap", at = @At("HEAD"))
    private void hexdebug$printDebugMishap(class_2561 mishapDisplay, CallbackInfo ci) {
        if (executionState != null) {
            var debugEnv = ((IMixinCircleExecutionState) executionState).getDebugEnv$hexdebug();
            if (debugEnv != null) {
                debugEnv.printDebugMessage(mishapDisplay, DebugOutputCategory.STDERR);
            }
        }
    }

    @WrapOperation(
        method = "postNoExits",
        at = @At(
            value = "INVOKE",
            target = "Lat/petrak/hexcasting/api/casting/circles/BlockEntityAbstractImpetus;postDisplay(Lnet/minecraft/network/chat/Component;Lnet/minecraft/world/item/ItemStack;)V"
        )
    )
    private void hexdebug$printDebugNoExits(
        BlockEntityAbstractImpetus instance,
        class_2561 error,
        class_1799 display,
        Operation<Void> original
    ) {
        if (executionState != null) {
            var debugEnv = ((IMixinCircleExecutionState) executionState).getDebugEnv$hexdebug();
            if (debugEnv != null) {
                debugEnv.printDebugMessage(error, DebugOutputCategory.STDERR, false);
            }
        }
        original.call(instance, error, display);
    }
}
