package gay.object.hexdebug.api.splicing;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import gay.object.hexdebug.utils.ExtensionsKt;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * A client-side representation of an iota in the Splicing Table's main list.
 * <br>
 * NOTE: Consumers should not construct this class themselves, as its fields may change at any time.
 * All constructors are annotated with {@link ApiStatus.Internal} to indicate this.
 * @param tag The raw iota NBT.
 * @param display The formatted iota for use in tooltips. For patterns (including those nested in
 *                lists), this is the pattern's name as calculated on the server, so that per-world
 *                patterns and special handlers can be displayed with their actual names instead of
 *                just the raw angle signature.
 * @param hexpatternSource The iota converted to a plain string in {@code .hexpattern} format.
 * @param index The index of this iota in the list.
 * @param depth The number of unclosed Introspection patterns preceding this iota.
 */
public record SplicingTableIotaClientView(
    @NotNull class_2487 tag,
    @NotNull class_2561 display,
    @NotNull String hexpatternSource,
    int index,
    int depth
) {
    @ApiStatus.Internal
    public SplicingTableIotaClientView {}

    @ApiStatus.Internal
    public SplicingTableIotaClientView(
        @NotNull Iota iota,
        @NotNull CastingEnvironment env,
        int index,
        int depth
    ) {
        this(
            IotaType.serialize(iota),
            ExtensionsKt.displayWithPatternName(iota, env),
            ExtensionsKt.toHexpatternSource(iota, env),
            index,
            depth
        );
    }

    @Nullable
    public class_2520 getData() {
        return tag.method_10580(HexIotaTypes.KEY_DATA);
    }
}
