package gay.object.hexdebug.mixin;

import at.petrak.hexcasting.client.ShiftScrollListener;
import gay.object.hexdebug.config.HexDebugConfig;
import gay.object.hexdebug.items.DebuggerItem;
import gay.object.hexdebug.registry.HexDebugItems;
import net.minecraft.class_1792;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Contract;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// client side
@Mixin(ShiftScrollListener.class)
public abstract class MixinShiftScrollListener {
    @Shadow(remap = false)
    private static double offHandDelta;

    @Contract
    @Invoker(value = "IsScrollableItem", remap = false)
    public static boolean hexdebug$invokeIsScrollableItem(class_1792 item) {
        throw new AssertionError();
    }

    @Inject(method = "IsScrollableItem", at = @At("RETURN"), cancellable = true)
    private static void hexdebug$IsScrollableItem(class_1792 item, CallbackInfoReturnable<Boolean> cir) {
        if (item == HexDebugItems.DEBUGGER.getValue()) {
            cir.setReturnValue(true);
        }
    }

    // TODO: the duplicated logic here feels nasty, but everything else I tried had issues with remapping
    @Inject(method = "onScroll", at = @At("HEAD"), cancellable = true, remap = false)
    private static void hexdebug$preferOffhandIfNotDebugging(double delta, boolean needsSneaking, CallbackInfoReturnable<Boolean> cir) {
        var player = class_310.method_1551().field_1724;
        if (
            // onScroll preconditions
            player != null
            && (player.method_5715() || !needsSneaking)
            && !player.method_7325()
            // additional logic
            && HexDebugConfig.INSTANCE.getClient().getSmartDebuggerSneakScroll()
            && !DebuggerItem.isDebugging()
            && player.method_6047().method_7909() == HexDebugItems.DEBUGGER.getValue()
            && hexdebug$invokeIsScrollableItem(player.method_6079().method_7909())
        ) {
            offHandDelta += delta;
            cir.setReturnValue(true);
        }
    }
}
