/*
 * Decompiled with CFR 0.152.
 */
package gay.object.hexdebug;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.utils.HexUtils;
import dev.architectury.event.events.client.ClientPlayerEvent;
import gay.object.hexdebug.HexDebug;
import gay.object.hexdebug.adapter.proxy.DebugProxyClient;
import gay.object.hexdebug.api.client.splicing.SplicingTableIotaRendererParser;
import gay.object.hexdebug.api.client.splicing.SplicingTableIotaRenderers;
import gay.object.hexdebug.blocks.focusholder.FocusHolderBlock;
import gay.object.hexdebug.blocks.focusholder.FocusHolderBlockEntity;
import gay.object.hexdebug.config.HexDebugClientConfig;
import gay.object.hexdebug.config.HexDebugServerConfig;
import gay.object.hexdebug.gui.splicing.renderers.ItemRendererProvider;
import gay.object.hexdebug.gui.splicing.renderers.LayersRendererProvider;
import gay.object.hexdebug.gui.splicing.renderers.ListRendererProvider;
import gay.object.hexdebug.gui.splicing.renderers.PatternRenderer;
import gay.object.hexdebug.gui.splicing.renderers.SubIotaRendererProvider;
import gay.object.hexdebug.gui.splicing.renderers.TextureRendererProvider;
import gay.object.hexdebug.gui.splicing.renderers.conditional.IfPathExistsRendererProvider;
import gay.object.hexdebug.gui.splicing.widgets.BaseIotaButton;
import gay.object.hexdebug.registry.HexDebugBlocks;
import gay.object.hexdebug.utils.ExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0015J3\u0010\u0017\u001a\u001e\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00100\u00100\u000e2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u000f\u0010\u001a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u000f\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0003R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lgay/object/hexdebug/HexDebugClient;", "", "<init>", "()V", "", "addScryingLensOverlays", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "getConfigScreen", "(Lnet/minecraft/client/gui/screens/Screen;)Lnet/minecraft/client/gui/screens/Screen;", "Lnet/minecraft/world/item/Item;", "item", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/network/chat/Component;", "Lgay/object/hexdebug/ScryingLensLine;", "getIotaLine", "(Lnet/minecraft/world/item/Item;Lnet/minecraft/nbt/CompoundTag;)Lcom/mojang/datafixers/util/Pair;", "stack", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/nbt/CompoundTag;)Lcom/mojang/datafixers/util/Pair;", "kotlin.jvm.PlatformType", "getItemLine", "(Lnet/minecraft/world/item/ItemStack;)Lcom/mojang/datafixers/util/Pair;", "init", "invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt", "registerSplicingTableIotaRenderers", "", "MAX_IOTA_DISPLAY_LINES", "I", "hexdebug-common"})
public final class HexDebugClient {
    @NotNull
    public static final HexDebugClient INSTANCE = new HexDebugClient();
    private static final int MAX_IOTA_DISPLAY_LINES = 4;

    private HexDebugClient() {
    }

    public final void init() {
        HexDebug.LOGGER.info("Hiding cognitohazards in your client...");
        HexDebugServerConfig.INSTANCE.initClient();
        HexDebugClientConfig.INSTANCE.init();
        DebugProxyClient.Companion.init();
        this.addScryingLensOverlays();
        this.registerSplicingTableIotaRenderers();
        this.invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt();
    }

    @NotNull
    public final Screen getConfigScreen(@NotNull Screen parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object t = AutoConfig.getConfigScreen(HexDebugClientConfig.GlobalConfig.class, (Screen)parent).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Screen)t;
    }

    private final void addScryingLensOverlays() {
        ScryingLensOverlayRegistry.addDisplayer((ResourceLocation)HexDebugBlocks.FOCUS_HOLDER.getId(), HexDebugClient::addScryingLensOverlays$lambda$2);
    }

    private final com.mojang.datafixers.util.Pair<ItemStack, Component> getItemLine(ItemStack stack) {
        return new com.mojang.datafixers.util.Pair((Object)stack, (Object)ExtensionsKt.getStyledHoverName(stack));
    }

    private final com.mojang.datafixers.util.Pair<ItemStack, Component> getIotaLine(Item item, CompoundTag tag) {
        return this.getIotaLine(new ItemStack((ItemLike)item), tag);
    }

    private final com.mojang.datafixers.util.Pair<ItemStack, Component> getIotaLine(ItemStack stack, CompoundTag tag) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int maxWidth = (int)((float)mc.getWindow().getGuiScaledWidth() / 2.0f * 0.8f);
        Component fullDisplay = IotaType.getDisplay((CompoundTag)tag);
        List displayLines = font.getSplitter().splitLines((FormattedText)fullDisplay, maxWidth, Style.EMPTY);
        MutableComponent truncatedDisplay = Component.empty();
        Iterator iterator2 = displayLines.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            FormattedText line = (FormattedText)iterator2.next();
            if (i > 0) {
                Intrinsics.checkNotNull((Object)truncatedDisplay);
                HexUtils.plusAssign((MutableComponent)truncatedDisplay, (Component)((Component)HexUtils.getAsTextComponent((String)" ")));
            }
            if (i >= 4) {
                Intrinsics.checkNotNull((Object)truncatedDisplay);
                HexUtils.plusAssign((MutableComponent)truncatedDisplay, (Component)((Component)HexUtils.getGray((MutableComponent)HexUtils.getAsTextComponent((String)"..."))));
                break;
            }
            Intrinsics.checkNotNull((Object)truncatedDisplay);
            Intrinsics.checkNotNull((Object)line);
            HexUtils.plusAssign((MutableComponent)truncatedDisplay, (Component)ExtensionsKt.toComponent(line));
        }
        return new com.mojang.datafixers.util.Pair((Object)stack, (Object)truncatedDisplay);
    }

    private final void registerSplicingTableIotaRenderers() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"conditional/if_path_exists", IfPathExistsRendererProvider.Companion.getPARSER()), TuplesKt.to((Object)"item", ItemRendererProvider.Companion.getPARSER()), TuplesKt.to((Object)"layers", LayersRendererProvider.Companion.getPARSER()), TuplesKt.to((Object)"list", ListRendererProvider.Companion.getPARSER()), TuplesKt.to((Object)"pattern", PatternRenderer.Companion.getPARSER()), TuplesKt.to((Object)"sub_iota", SubIotaRendererProvider.Companion.getPARSER()), TuplesKt.to((Object)"texture", TextureRendererProvider.Companion.getPARSER())};
        for (Pair pair : pairArray) {
            String name = (String)pair.component1();
            SplicingTableIotaRendererParser parser = (SplicingTableIotaRendererParser)pair.component2();
            SplicingTableIotaRenderers.register(HexDebug.id(name), parser);
        }
    }

    private final void invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt() {
        HexDebugClientConfig.getHolder().registerSaveListener(HexDebugClient::invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt$lambda$3);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(HexDebugClient::invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt$lambda$4);
    }

    private static final void addScryingLensOverlays$lambda$2(List lines, BlockState blockState, BlockPos pos, Player player, Level level, Direction direction) {
        block2: {
            FocusHolderBlockEntity focusHolderBlockEntity;
            Intrinsics.checkNotNull((Object)level);
            BlockGetter blockGetter = (BlockGetter)level;
            Intrinsics.checkNotNull((Object)pos);
            FocusHolderBlockEntity focusHolderBlockEntity2 = FocusHolderBlock.Companion.getBlockEntity(blockGetter, pos);
            if (focusHolderBlockEntity2 == null) break block2;
            FocusHolderBlockEntity $this$addScryingLensOverlays_u24lambda_u242_u24lambda_u241 = focusHolderBlockEntity = focusHolderBlockEntity2;
            boolean bl = false;
            if (!$this$addScryingLensOverlays_u24lambda_u242_u24lambda_u241.getIotaStack().isEmpty()) {
                Intrinsics.checkNotNull((Object)lines);
                ((Collection)lines).add(INSTANCE.getItemLine($this$addScryingLensOverlays_u24lambda_u242_u24lambda_u241.getIotaStack()));
                CompoundTag compoundTag = $this$addScryingLensOverlays_u24lambda_u242_u24lambda_u241.readIotaTag();
                if (compoundTag != null) {
                    CompoundTag it = compoundTag;
                    boolean bl2 = false;
                    Collection collection = lines;
                    Item item = Items.PAPER;
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"PAPER");
                    collection.add(INSTANCE.getIotaLine(item, it));
                }
            }
        }
    }

    private static final InteractionResult invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt$lambda$3(ConfigHolder configHolder, HexDebugClientConfig.GlobalConfig globalConfig) {
        BaseIotaButton.Companion.invalidateRendererCache();
        return InteractionResult.PASS;
    }

    private static final void invalidateIotaRendererCacheWhenThingsHappenThatShouldInvalidateIt$lambda$4(LocalPlayer it) {
        BaseIotaButton.Companion.invalidateRendererCache();
    }
}

