/*
 * Decompiled with CFR 0.152.
 */
package gay.object.hexdebug.adapter;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import gay.object.hexdebug.HexDebug;
import gay.object.hexdebug.adapter.DebugAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\u0010J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0011H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bJ\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lgay/object/hexdebug/adapter/DebugAdapterManager;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "add", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lgay/object/hexdebug/adapter/DebugAdapter;", "get", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lgay/object/hexdebug/adapter/DebugAdapter;", "Ljava/util/UUID;", "playerUUID", "(Ljava/util/UUID;)Lgay/object/hexdebug/adapter/DebugAdapter;", "Lnet/minecraft/world/entity/player/Player;", "(Lnet/minecraft/world/entity/player/Player;)Lgay/object/hexdebug/adapter/DebugAdapter;", "init", "remove", "removeAll", "", "debugAdapters", "Ljava/util/Map;", "hexdebug-common"})
@SourceDebugExtension(value={"SMAP\nDebugAdapterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugAdapterManager.kt\ngay/object/hexdebug/adapter/DebugAdapterManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class DebugAdapterManager {
    @NotNull
    public static final DebugAdapterManager INSTANCE = new DebugAdapterManager();
    @NotNull
    private static final Map<UUID, DebugAdapter> debugAdapters = new LinkedHashMap();

    private DebugAdapterManager() {
    }

    @Nullable
    public final DebugAdapter get(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        return debugAdapters.get(playerUUID);
    }

    @Nullable
    public final DebugAdapter get(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return debugAdapters.get(player.getUUID());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final DebugAdapter get(@NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        LivingEntity livingEntity = env.getCastingEntity();
        LivingEntity livingEntity2 = livingEntity;
        if (livingEntity == null) return null;
        LivingEntity it = livingEntity2;
        boolean bl = false;
        if (!(it instanceof Player)) return null;
        Player player = (Player)it;
        livingEntity2 = player;
        if (player == null) return null;
        it = livingEntity2;
        boolean bl2 = false;
        DebugAdapter debugAdapter = INSTANCE.get((Player)it);
        return debugAdapter;
    }

    public final void init() {
        PlayerEvent.PLAYER_JOIN.register(DebugAdapterManager::init$lambda$2);
        PlayerEvent.PLAYER_QUIT.register(DebugAdapterManager::init$lambda$3);
        EntityEvent.LIVING_DEATH.register(DebugAdapterManager::init$lambda$4);
        LifecycleEvent.SERVER_STOPPING.register(DebugAdapterManager::init$lambda$5);
    }

    private final void add(ServerPlayer player) {
        HexDebug.LOGGER.debug("Adding debug adapter for {}", (Object)player.getUUID());
        Map<UUID, DebugAdapter> map = debugAdapters;
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID uUID2 = uUID;
        DebugAdapter debugAdapter = new DebugAdapter(player);
        map.put(uUID2, debugAdapter);
    }

    private final void remove(ServerPlayer player) {
        HexDebug.LOGGER.debug("Removing debug adapter for {}", (Object)player.getUUID());
        DebugAdapter debugAdapter = this.get((Player)player);
        if (debugAdapter != null) {
            debugAdapter.onRemove();
        }
        debugAdapters.remove(player.getUUID());
    }

    private final void removeAll() {
        HexDebug.LOGGER.debug("Removing {} debug adapters", (Object)debugAdapters.size());
        for (DebugAdapter debugAdapter : debugAdapters.values()) {
            debugAdapter.onRemove();
        }
        debugAdapters.clear();
    }

    private static final void init$lambda$2(ServerPlayer player) {
        Intrinsics.checkNotNull((Object)player);
        INSTANCE.add(player);
    }

    private static final void init$lambda$3(ServerPlayer player) {
        Intrinsics.checkNotNull((Object)player);
        INSTANCE.remove(player);
    }

    private static final EventResult init$lambda$4(LivingEntity entity, DamageSource damageSource) {
        block1: {
            if (!(entity instanceof ServerPlayer)) break block1;
            DebugAdapter debugAdapter = INSTANCE.get((Player)entity);
            if (debugAdapter != null) {
                debugAdapter.onDeath();
            }
        }
        return EventResult.pass();
    }

    private static final void init$lambda$5(MinecraftServer it) {
        INSTANCE.removeAll();
    }
}

