/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zson;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZsonValue {
    public static final String NO_COMMENT = "\u0000";
    @NotNull
    public String comment;
    @Nullable
    public Object value;
    @NotNull
    public String format;

    public ZsonValue(@NotNull String comment, @Nullable Object value, @NotNull String format) {
        this.comment = comment;
        this.value = value;
        this.format = format;
    }

    public ZsonValue(@NotNull String comment, @Nullable Object value) {
        this(comment, value, "%s");
    }

    public ZsonValue(@Nullable Object value) {
        this(NO_COMMENT, value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other instanceof ZsonValue) {
            ZsonValue v = (ZsonValue)other;
            if (Objects.equals(this.value, v.value)) return true;
        }
        if (!Objects.equals(other, this.value)) return false;
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ZsonValue{");
        if (!this.comment.equals(NO_COMMENT)) {
            sb.append("comment='").append(this.comment).append("', ");
        }
        if (!this.format.equals("%s")) {
            sb.append("format='").append(this.format).append("', ");
        }
        return sb.append("value=").append(this.value).append('}').toString();
    }
}

