/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zson;

import dev.nolij.zson.ZsonField;
import dev.nolij.zson.ZsonValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Zson {
    public String indent = "\t";
    public boolean expandArrays = false;
    public boolean quoteKeys = true;

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static Map.Entry<String, ZsonValue> entry(@NotNull String key, @NotNull String comment, @Nullable Object value) {
        return new AbstractMap.SimpleEntry<String, ZsonValue>(key, new ZsonValue(comment, value));
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static Map.Entry<String, ZsonValue> entry(@NotNull String key, @Nullable Object value) {
        return new AbstractMap.SimpleEntry<String, ZsonValue>(key, new ZsonValue(value));
    }

    @SafeVarargs
    @NotNull
    @Contract(value="_ -> new")
    public static Map<String, ZsonValue> object(Map.Entry<String, ZsonValue> ... entries) {
        LinkedHashMap<String, ZsonValue> map = new LinkedHashMap<String, ZsonValue>();
        for (Map.Entry<String, ZsonValue> e : entries) {
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static List<?> array(Object ... values) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, values);
        return list;
    }

    public static <E extends Enum<E>> void convertEnum(Map<String, ZsonValue> json, String key, Class<E> enumClass) {
        ZsonValue value = json.get(key);
        if (value == null) {
            return;
        }
        Object object = value.value;
        if (object instanceof String) {
            String s = (String)object;
            json.put(key, new ZsonValue(value.comment, Enum.valueOf(enumClass, s)));
        } else if (!enumClass.isInstance(value.value)) {
            throw new IllegalArgumentException(Zson.jvmdowngrader$concat$convertEnum$1(String.valueOf(value.value)));
        }
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String unescape(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        char[] chars = string.toCharArray();
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c;
            int c2 = chars[i];
            if (c2 != 92) {
                chars[j++] = c2;
                continue;
            }
            if (i + 1 >= chars.length) {
                throw new IllegalArgumentException("Invalid escape sequence: \\EOS");
            }
            int d = chars[++i];
            switch (d) {
                case 98: {
                    c = 8;
                    break;
                }
                case 102: {
                    c = 12;
                    break;
                }
                case 110: {
                    c = 10;
                    break;
                }
                case 114: {
                    c = 13;
                    break;
                }
                case 115: {
                    c = 32;
                    break;
                }
                case 116: {
                    c = 9;
                    break;
                }
                case 10: 
                case 13: 
                case 34: 
                case 39: 
                case 92: {
                    c = d;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (d == 48 && (i + 1 >= chars.length || chars[i + 1] < '0' || chars[i + 1] > '9')) {
                        c = 0;
                        break;
                    }
                    int limit = d < 52 ? 2 : 1;
                    int code = d - 48;
                    for (int k = 1; k < limit; ++k) {
                        char e = chars[i + 1];
                        if (e < '0' || e > '9') continue;
                        code = code * 10 + e - 48;
                        ++i;
                    }
                    c = (char)code;
                    break;
                }
                case 117: {
                    String hex = new String(chars, i, 4);
                    if (hex.length() != 4) {
                        throw new IllegalArgumentException(Zson.jvmdowngrader$concat$unescape$1(hex));
                    }
                    i += 4;
                    c = (char)Integer.parseInt(hex, 16);
                    break;
                }
                default: {
                    c = d;
                }
            }
            c2 = c;
            chars[j++] = c2;
        }
        return new String(chars, 0, j);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String escape(@Nullable String string, char escapeQuotes) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder result = new StringBuilder(string.length());
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': {
                    result.append("\\0");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\"': 
                case '\'': {
                    if (escapeQuotes == c) {
                        result.append('\\');
                    }
                    result.append(c);
                    continue block10;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                default: {
                    int type = Character.getType(c);
                    if (type != 0 && type != 15 && type != 19) {
                        result.append(c);
                        continue block10;
                    }
                    if (c < '\u0010') {
                        result.append("\\x0").append(Character.forDigit(c, 16));
                        continue block10;
                    }
                    String hex = Integer.toHexString(c);
                    if (c < '\u0100') {
                        result.append("\\x").append(hex);
                        continue block10;
                    }
                    if (c < '\u1000') {
                        result.append("\\u0").append(hex);
                        continue block10;
                    }
                    result.append("\\u").append(hex);
                }
            }
        }
        return result.toString();
    }

    @NotNull
    @Contract(value="_ -> new")
    public static Map<String, ZsonValue> obj2Map(@Nullable Object object) {
        if (object == null) {
            return Zson.object(new Map.Entry[0]);
        }
        Map<String, ZsonValue> map = Zson.object(new Map.Entry[0]);
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!Zson.shouldInclude(field, true)) continue;
            ZsonField annotation = field.getAnnotation(ZsonField.class);
            String comment = annotation == null ? "\u0000" : annotation.comment();
            String format = annotation == null ? "%s" : annotation.format();
            try {
                ArrayList<Object> list;
                ArrayList<Object> value;
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                if ((value = field.get(object)) instanceof Map) {
                    value = Zson.obj2Map(value);
                } else if (value instanceof Iterable) {
                    list = new ArrayList<Object>();
                    for (Object o : (Iterable)value) {
                        list.add(o);
                    }
                    value = list;
                } else if (value != null && value.getClass().isArray()) {
                    list = new ArrayList();
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        list.add(Array.get(value, i));
                    }
                    value = list;
                }
                map.put(field.getName(), new ZsonValue(comment, value, format));
                if (accessible) continue;
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(Zson.jvmdowngrader$concat$obj2Map$1(field.getName()), e);
            }
        }
        return map;
    }

    @NotNull
    @Contract(value="_ , _ -> new")
    public static <T> T map2Obj(@NotNull Map<String, ZsonValue> map, @NotNull Class<T> type) {
        try {
            Object object;
            if (type.isArray()) {
                object = Array.newInstance(type.getComponentType(), map.size());
            } else {
                try {
                    object = type.getDeclaredConstructor(Map.class).newInstance(map);
                }
                catch (ReflectiveOperationException ignored) {
                    object = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            for (Field field : type.getDeclaredFields()) {
                if (!Zson.shouldInclude(field, false) || !map.containsKey(field.getName())) continue;
                Zson.setField(field, object, map.get((Object)field.getName()).value);
            }
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(Zson.jvmdowngrader$concat$map2Obj$1(type.getSimpleName()), e);
        }
    }

    private static boolean shouldInclude(Field field, boolean serializing) {
        boolean defaultInclude;
        ZsonField value = field.getAnnotation(ZsonField.class);
        int modifiers = field.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            return false;
        }
        if (!serializing && Modifier.isFinal(modifiers)) {
            return false;
        }
        boolean bl = defaultInclude = (serializing || !Modifier.isStatic(modifiers)) && Modifier.isPublic(modifiers);
        if (value == null) {
            return defaultInclude;
        }
        if (serializing && value.deserializeOnly()) {
            return false;
        }
        if (!serializing && value.serializeOnly()) {
            return false;
        }
        if (value.exclude()) {
            return false;
        }
        return defaultInclude || serializing && value.include();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void setField(Field field, Object object, Object value) {
        Class<?> type = field.getType();
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            if (type.isPrimitive()) {
                String string = type.getName();
                int n = -1;
                switch (string.hashCode()) {
                    case 64711720: {
                        if (!string.equals("boolean")) break;
                        n = 0;
                        break;
                    }
                    case 109413500: {
                        if (!string.equals("short")) break;
                        n = 1;
                        break;
                    }
                    case 104431: {
                        if (!string.equals("int")) break;
                        n = 2;
                        break;
                    }
                    case 97526364: {
                        if (!string.equals("float")) break;
                        n = 3;
                        break;
                    }
                    case -1325958191: {
                        if (!string.equals("double")) break;
                        n = 4;
                        break;
                    }
                    case 3327612: {
                        if (!string.equals("long")) break;
                        n = 5;
                        break;
                    }
                    case 3039496: {
                        if (!string.equals("byte")) break;
                        n = 6;
                        break;
                    }
                    case 3052374: {
                        if (!string.equals("char")) break;
                        n = 7;
                    }
                }
                switch (n) {
                    case 0: {
                        field.setBoolean(object, (Boolean)value);
                        return;
                    }
                    case 1: {
                        field.setShort(object, ((Number)value).shortValue());
                        return;
                    }
                    case 2: {
                        field.setInt(object, ((Number)value).intValue());
                        return;
                    }
                    case 3: {
                        field.setFloat(object, ((Number)value).floatValue());
                        return;
                    }
                    case 4: {
                        field.setDouble(object, ((Number)value).doubleValue());
                        return;
                    }
                    case 5: {
                        field.setLong(object, ((Number)value).longValue());
                        return;
                    }
                    case 6: {
                        field.setByte(object, ((Number)value).byteValue());
                        return;
                    }
                    case 7: {
                        field.setChar(object, ((String)value).charAt(0));
                    }
                }
                return;
            }
            Collection finalValue = value;
            if (type.isEnum() && value instanceof String) {
                finalValue = Enum.valueOf(type, (String)value);
            } else if (type.isArray() && value instanceof Iterable) {
                Iterable itr = (Iterable)value;
                int size = 0;
                for (Object ignored : itr) {
                    ++size;
                }
                Object array = Array.newInstance(type.getComponentType(), size);
                int i = 0;
                for (Object o : itr) {
                    Array.set(array, i++, o);
                }
                finalValue = array;
            } else if (value instanceof Map && !Map.class.isAssignableFrom(type)) {
                finalValue = Zson.map2Obj((Map)value, type);
            } else if (Collection.class.isAssignableFrom(type)) {
                Collection collection;
                if (type.isInterface()) {
                    if (List.class.isAssignableFrom(type)) {
                        collection = new ArrayList();
                    } else {
                        if (!Set.class.isAssignableFrom(type)) throw new IllegalArgumentException(Zson.jvmdowngrader$concat$setField$1(String.valueOf(type)));
                        collection = new LinkedHashSet();
                    }
                } else {
                    collection = (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        collection.add(Array.get(value, i));
                    }
                } else {
                    if (!(value instanceof Iterable)) throw new IllegalArgumentException(Zson.jvmdowngrader$concat$setField$2(String.valueOf(value.getClass())));
                    Iterable itr = (Iterable)value;
                    for (Object o : itr) {
                        collection.add(o);
                    }
                }
                finalValue = collection;
            }
            field.set(object, finalValue);
            return;
        }
        catch (Exception e) {
            throw new AssertionError(Zson.jvmdowngrader$concat$setField$1(field.getName(), type.getSimpleName(), String.valueOf(value), value.getClass().getSimpleName()), e);
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T parseFile(@NotNull Path path) throws IOException {
        T t;
        block5: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                t = Zson.parse(reader);
                if (reader == null) break block5;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                    }
                }
                throw throwable;
            }
            reader.close();
        }
        return t;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T parseString(@NotNull @Language(value="json5") String serialized) {
        try {
            return Zson.parse(new StringReader(serialized));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    @Contract(mutates="param")
    public static <T> T parse(Reader input) throws IOException {
        if (!input.markSupported()) {
            input = new BufferedReader(input);
        }
        while (Zson.skipWhitespace(input) || Zson.skipComment(input)) {
        }
        int ch = input.read();
        if (ch == -1) {
            throw Zson.unexpectedEOF();
        }
        switch (ch) {
            case 123: {
                return (T)Zson.parseObject(input);
            }
            case 91: {
                return (T)Zson.parseArray(input);
            }
            case 34: 
            case 39: {
                return (T)Zson.unescape(Zson.parseString(input, (char)ch));
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 73: 
            case 78: {
                return (T)Zson.parseNumber(input, (char)ch);
            }
            case 110: {
                char[] chars = new char[3];
                if (input.read(chars) == 3 && chars[0] == 'u' && chars[1] == 'l' && chars[2] == 'l') {
                    return null;
                }
                throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parse$1(new String(chars)));
            }
            case 102: 
            case 116: {
                return (T)Zson.parseBoolean(input, (char)ch);
            }
        }
        throw Zson.unexpected(ch);
    }

    @Contract(mutates="param")
    private static Map<String, ZsonValue> parseObject(Reader input) throws IOException {
        Map<String, ZsonValue> map = Zson.object(new Map.Entry[0]);
        boolean comma = false;
        boolean colon = false;
        String key = null;
        while (true) {
            if (Zson.skipWhitespace(input) || Zson.skipComment(input)) {
                continue;
            }
            input.mark(1);
            int ch = input.read();
            if (ch == 125) {
                return map;
            }
            if (comma) {
                if (ch != 44) {
                    throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parseObject$1((char)ch));
                }
                comma = false;
                continue;
            }
            if (colon) {
                if (ch != 58) {
                    throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parseObject$2((char)ch));
                }
                colon = false;
                continue;
            }
            if (ch == -1) {
                throw Zson.unexpectedEOF();
            }
            if (key == null) {
                String string;
                switch (ch) {
                    case 34: 
                    case 39: {
                        string = Zson.unescape(Zson.parseString(input, (char)ch));
                        break;
                    }
                    default: {
                        if (Character.isJavaIdentifierStart(ch) || ch == 92) {
                            string = Zson.parseIdentifier(input, ch);
                            break;
                        }
                        throw Zson.unexpected(ch);
                    }
                }
                key = string;
                colon = true;
                continue;
            }
            input.reset();
            Object value = Zson.parse(input);
            map.put(key, new ZsonValue(value));
            key = null;
            comma = true;
        }
    }

    @Contract(mutates="param")
    private static List<Object> parseArray(Reader input) {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean comma = false;
        try {
            while (true) {
                if (Zson.skipWhitespace(input) || Zson.skipComment(input)) {
                    continue;
                }
                input.mark(1);
                int ch = input.read();
                if (ch == 93) {
                    return list;
                }
                if (comma) {
                    if (ch != 44) {
                        throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parseObject$1((char)ch));
                    }
                    comma = false;
                    continue;
                }
                if (ch == -1) {
                    throw Zson.unexpectedEOF();
                }
                input.reset();
                Object value = Zson.parse(input);
                list.add(value);
                comma = true;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Contract(mutates="param1")
    private static String parseString(Reader input, char start) throws IOException {
        int c;
        int escapes = 0;
        StringBuilder output = new StringBuilder();
        while ((c = input.read()) != -1) {
            if (c == start) {
                if (escapes == 0) {
                    return output.toString();
                }
                output.append(Character.toChars(c));
                --escapes;
            }
            if (Zson.isLineTerminator(c)) {
                if (escapes == 0) {
                    if (c == 8232 || c == 8233) {
                        System.err.println("[ZSON] Warning: unescaped line separator in string literal");
                    } else {
                        throw new IllegalArgumentException("Unexpected newline");
                    }
                }
                escapes = 0;
                continue;
            }
            if (c == 92) {
                if (++escapes != 2) continue;
                output.append("\\\\");
                escapes = 0;
                continue;
            }
            if (escapes == 1) {
                output.append('\\');
            }
            output.append(Character.toChars(c));
            escapes = 0;
        }
        throw Zson.unexpectedEOF();
    }

    @Contract(mutates="param1")
    private static String parseIdentifier(Reader input, int start) throws IOException {
        int c;
        boolean escaped;
        StringBuilder output = new StringBuilder();
        boolean bl = escaped = start == 92;
        if (!escaped) {
            output.append((char)start);
        }
        input.mark(1);
        while ((c = input.read()) != -1) {
            if (escaped) {
                if (c == 110 || c == 114) {
                    throw Zson.unexpected(c);
                }
                output.append(Zson.unescape(Zson.jvmdowngrader$concat$parseIdentifier$1((char)c)));
                input.mark(1);
                escaped = false;
                continue;
            }
            if (c == 92) {
                input.mark(1);
                escaped = true;
                continue;
            }
            if (Zson.isIdentifierChar(c)) {
                input.mark(1);
                output.append(Character.toChars(c));
                continue;
            }
            input.reset();
            return output.toString();
        }
        throw Zson.unexpectedEOF();
    }

    private static boolean isIdentifierChar(int c) {
        if (c == 95 || c == 36) {
            return true;
        }
        int type = Character.getType(c);
        return type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 10 || type == 6 || type == 8 || type == 9 || type == 23;
    }

    private static boolean isWhitespace(int c) {
        return c == 9 || c == 10 || c == 12 || c == 13 || c == 32 || c == 160 || c == 65279 || Character.getType(c) == 12;
    }

    private static boolean isLineTerminator(int c) {
        return c == 10 || c == 13 || c == 8232 || c == 8233;
    }

    @Contract(mutates="param1")
    private static Boolean parseBoolean(Reader input, char start) throws IOException {
        if (start == 't') {
            char[] chars = new char[3];
            if (input.read(chars) == 3 && chars[0] == 'r' && chars[1] == 'u' && chars[2] == 'e') {
                return true;
            }
            throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parseBoolean$1(new String(chars)));
        }
        char[] chars = new char[4];
        if (input.read(chars) == 4 && chars[0] == 'a' && chars[1] == 'l' && chars[2] == 's' && chars[3] == 'e') {
            return false;
        }
        throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parseBoolean$2(new String(chars)));
    }

    @Contract(mutates="param1")
    private static Number parseNumber(Reader input, char start) throws IOException {
        switch (start) {
            case '-': {
                Number number;
                Number numberValue;
                Number number2 = numberValue = Zson.parseNumber(input, (char)input.read());
                Objects.requireNonNull(number2);
                Number number3 = number2;
                int n = 0;
                switch (Zson.jvmdowngrader$switch$parseNumber$0(number3, n)) {
                    case 0: {
                        Double d = (Double)number3;
                        number = -d.doubleValue();
                        break;
                    }
                    case 1: {
                        Long l = (Long)number3;
                        number = -l.longValue();
                        break;
                    }
                    case 2: {
                        BigInteger b = (BigInteger)number3;
                        number = b.negate();
                        break;
                    }
                    default: {
                        number = -((Integer)numberValue).intValue();
                    }
                }
                return number;
            }
            case 'N': {
                int n = input.read();
                if (n != 97 || (n = input.read()) != 78) {
                    throw Zson.unexpected(n);
                }
                return Double.NaN;
            }
            case 'I': {
                char[] chars = new char[7];
                if (input.read(chars) != 7) {
                    throw Zson.unexpectedEOF();
                }
                if (!"nfinity".equals(new String(chars))) {
                    throw new IllegalArgumentException(Zson.jvmdowngrader$concat$parseNumber$1(new String(chars)));
                }
                return Double.POSITIVE_INFINITY;
            }
            case '+': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return Zson.parseDecimal(input, start);
            }
            case '0': {
                input.mark(1);
                int c = input.read();
                if (c == 120 || c == 88) {
                    StringBuilder hexValueBuilder = new StringBuilder();
                    input.mark(1);
                    while ((c = input.read()) != -1) {
                        if (Character.isDigit(c) || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
                            input.mark(1);
                            hexValueBuilder.append(Character.toChars(c));
                            continue;
                        }
                        input.reset();
                        long l = Long.parseLong(hexValueBuilder.toString().toUpperCase(Locale.ROOT), 16);
                        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                            return (int)l;
                        }
                        return l;
                    }
                    throw Zson.unexpectedEOF();
                }
                input.reset();
                return Zson.parseDecimal(input, '0');
            }
            case '.': {
                return Zson.parseDecimal(input, '.');
            }
        }
        throw Zson.unexpected(start);
    }

    @Contract(mutates="param1")
    private static Number parseDecimal(Reader input, char c) throws IOException {
        int ch;
        StringBuilder stringValueBuilder = new StringBuilder().append(c);
        input.mark(1);
        while ((ch = input.read()) != -1) {
            if (Character.isDigit(ch) || ch == 46 || ch == 101 || ch == 69 || ch == 43 || ch == 45) {
                input.mark(1);
                stringValueBuilder.append(Character.toChars(ch));
                continue;
            }
            input.reset();
            String stringValue = stringValueBuilder.toString();
            if (stringValue.contains(".") || stringValue.contains("e") || stringValue.contains("E")) {
                return Double.parseDouble(stringValue);
            }
            Number number = null;
            try {
                BigInteger bigIntValue;
                number = bigIntValue = new BigInteger(stringValue);
                number = bigIntValue.longValueExact();
                number = bigIntValue.intValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return number;
        }
        throw Zson.unexpectedEOF();
    }

    @Contract(mutates="param")
    private static boolean skipWhitespace(Reader input) throws IOException {
        int c;
        input.mark(1);
        int skipped = 0;
        while ((c = input.read()) != -1) {
            if (!Zson.isWhitespace(c) && !Zson.isLineTerminator(c)) {
                input.reset();
                return skipped != 0;
            }
            ++skipped;
            input.mark(1);
        }
        throw Zson.unexpectedEOF();
    }

    @Contract(mutates="param")
    private static boolean skipComment(Reader input) throws IOException {
        input.mark(2);
        int c = input.read();
        if (c == 47) {
            int c2 = input.read();
            if (c2 == 47) {
                while ((c = input.read()) != -1 && c != 10) {
                }
                return true;
            }
            if (c2 == 42) {
                while ((c = input.read()) != -1) {
                    if (c != 42 || input.read() != 47) continue;
                    return true;
                }
                throw Zson.unexpectedEOF();
            }
            input.reset();
        } else {
            input.reset();
        }
        return false;
    }

    @Contract(value="_ -> fail")
    private static IllegalArgumentException unexpected(int ch) {
        return new IllegalArgumentException(Zson.jvmdowngrader$concat$unexpected$1((char)ch));
    }

    @Contract(value=" -> fail")
    private static IllegalArgumentException unexpectedEOF() {
        return new IllegalArgumentException("Unexpected EOF");
    }

    @NotNull
    public String stringify(@NotNull Map<String, ZsonValue> data) {
        StringWriter output = new StringWriter();
        try {
            this.write(data, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(mutates="param2")
    public void write(@NotNull Map<String, ZsonValue> data, @NotNull Path path) throws IOException {
        BufferedWriter output = Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            this.write(data, output);
            ((Writer)output).flush();
            if (output == null) return;
        }
        catch (Throwable throwable) {
            if (output == null) throw throwable;
            try {
                ((Writer)output).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
            }
            throw throwable;
        }
        ((Writer)output).close();
    }

    @Contract(mutates="param2")
    public void write(@NotNull Map<String, ZsonValue> data, @NotNull Appendable output) throws IOException {
        output.append("{\n");
        boolean first = true;
        for (Map.Entry<String, ZsonValue> entry : data.entrySet()) {
            if (first) {
                first = false;
            } else {
                output.append(",\n");
            }
            ZsonValue zv = entry.getValue();
            String comment = zv.comment;
            if (!"\u0000".equals(comment)) {
                for (String line : comment.split("\n")) {
                    output.append(this.indent).append("// ").append(line).append("\n");
                }
            }
            output.append(this.indent);
            if (this.quoteKeys) {
                output.append('\"');
            }
            output.append(this.checkIdentifier(entry.getKey()));
            if (this.quoteKeys) {
                output.append('\"');
            }
            output.append(": ").append(this.value(zv.value, zv.format));
        }
        output.append("\n}");
    }

    private String checkIdentifier(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        char c = key.charAt(0);
        if (!Character.isJavaIdentifierStart((int)c) && c != '\\') {
            throw new IllegalArgumentException(Zson.jvmdowngrader$concat$checkIdentifier$1(key.charAt(0)));
        }
        for (int i = 1; i < key.length(); ++i) {
            if (Zson.isIdentifierChar(key.charAt(i))) continue;
            throw new IllegalArgumentException(Zson.jvmdowngrader$concat$checkIdentifier$1(key));
        }
        return key;
    }

    public String value(Object value, String format) {
        if (value instanceof Map) {
            try {
                return this.stringify((Map)value).replace("\n", Zson.jvmdowngrader$concat$value$1(this.indent));
            }
            catch (ClassCastException e) {
                if (e.getMessage().contains("cannot be cast to")) {
                    throw new ClassCastException(Zson.jvmdowngrader$concat$value$2(value.getClass().getName()));
                }
                throw e;
            }
            catch (StackOverflowError e) {
                throw new StackOverflowError("Map is circular");
            }
        }
        if (value instanceof String || value instanceof Character) {
            return Zson.jvmdowngrader$concat$value$3(Zson.escape(J_L_String.formatted((String)format, (Object[])new Object[]{value.toString()}), '\"'));
        }
        if (value instanceof Number || value instanceof Boolean || value == null) {
            return J_L_String.formatted((String)format, (Object[])new Object[]{value});
        }
        if (value instanceof Iterable) {
            Iterable iterableValue = (Iterable)value;
            StringBuilder output = new StringBuilder("[");
            String indent = this.expandArrays ? this.indent : " ";
            output.append(indent);
            boolean first = true;
            for (Object obj : iterableValue) {
                if (!first) {
                    output.append(",").append(indent);
                } else {
                    first = false;
                }
                if (this.expandArrays) {
                    output.append(indent).append(indent);
                }
                output.append(this.value(obj, format).replace("\n", Zson.jvmdowngrader$concat$value$1(indent, indent)));
            }
            output.append(indent);
            if (this.expandArrays) {
                output.append(indent);
            }
            return output.append("]").toString();
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return Zson.jvmdowngrader$concat$value$3(J_L_String.formatted((String)format, (Object[])new Object[]{enumValue.name()}));
        }
        return J_L_String.formatted((String)format, (Object[])new Object[]{this.value(Zson.obj2Map(value))});
    }

    public String value(Object value) {
        return this.value(value, "%s");
    }

    @Contract(value="_ -> this", mutates="this")
    public Zson withIndent(String indent) {
        for (char c : indent.toCharArray()) {
            if (Zson.isWhitespace(c)) continue;
            throw new IllegalArgumentException(Zson.jvmdowngrader$concat$withIndent$1(indent));
        }
        this.indent = indent;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public Zson withExpandArrays(boolean expandArrays) {
        this.expandArrays = expandArrays;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public Zson withQuoteKeys(boolean quoteKeys) {
        this.quoteKeys = quoteKeys;
        return this;
    }

    private static /* synthetic */ int jvmdowngrader$switch$parseNumber$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 3) {
            throw new IndexOutOfBoundsException(Zson.jvmdowngrader$concat$jvmdowngrader$switch$parseNumber$0$1(n, 3));
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof Double) {
                        n2 = 0;
                        break;
                    }
                }
                case 1: {
                    if (object instanceof Long) {
                        n2 = 1;
                        break;
                    }
                }
                case 2: {
                    if (object instanceof BigInteger) {
                        n2 = 2;
                        break;
                    }
                }
                default: {
                    n2 = 3;
                }
            }
        }
        return n2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$convertEnum$1(String string) {
        return "Expected string, got " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$unescape$1(String string) {
        return "Invalid unicode escape: " + string + ", expected 4 characters, found EOS";
    }

    private static /* synthetic */ String jvmdowngrader$concat$obj2Map$1(String string) {
        return "Failed to get field " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$map2Obj$1(String string) {
        return "Failed to create object of type " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setField$1(String string) {
        return "Unsupported collection type: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setField$2(String string) {
        return "Expected array or iterable, got " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setField$1(String string, String string2, String string3, String string4) {
        return "Failed to set field " + string + " (type " + string2 + ") to " + string3 + " (type " + string4 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parse$1(String string) {
        return "Expected 'null', got 'n" + string + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseObject$1(char c) {
        return "Expected comma, got " + c;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseObject$2(char c) {
        return "Expected colon, got " + c;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseIdentifier$1(char c) {
        return "\\" + c;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBoolean$1(String string) {
        return "Expected 'true', got 't" + string + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBoolean$2(String string) {
        return "Expected 'false', got 'f" + string + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseNumber$1(String string) {
        return "Expected 'Infinity', got 'I" + string + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$unexpected$1(char c) {
        return "Unexpected character: " + c;
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkIdentifier$1(char c) {
        return "Key must start with a valid identifier character: " + c;
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkIdentifier$1(String string) {
        return "Key must be a valid Java identifier: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$value$1(String string) {
        return "\n" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$value$2(String string) {
        return "expected Map<String, ZsonValue>, got " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$value$3(String string) {
        return "\"" + string + "\"";
    }

    private static /* synthetic */ String jvmdowngrader$concat$value$1(String string, String string2) {
        return "\n" + string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$withIndent$1(String string) {
        return "Indent '" + string + "' must be a whitespace string";
    }

    private static /* synthetic */ String jvmdowngrader$concat$jvmdowngrader$switch$parseNumber$0$1(int n, int n2) {
        return "Index " + n + " out of bounds for length " + n2;
    }
}

