/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.debug;

import com.hollingsworth.nuggets.common.debug.DebugEvent;
import com.hollingsworth.nuggets.common.debug.EntityEvent;
import com.hollingsworth.nuggets.common.debug.FixedStack;
import com.hollingsworth.nuggets.common.debug.IDebugger;
import com.hollingsworth.nuggets.mixin.MobAccessor;
import java.io.PrintWriter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class EntityDebugger
implements IDebugger {
    public FixedStack<EntityEvent> events;
    public final Entity entity;

    public EntityDebugger(Entity entity) {
        this(entity, 100);
    }

    public EntityDebugger(Entity entity, int size) {
        this.entity = entity;
        this.events = new FixedStack(size);
    }

    @Override
    public void addEntityEvent(DebugEvent event, boolean storeDuplicate) {
        if (storeDuplicate || this.events.isEmpty() || !((EntityEvent)this.events.peek()).id.equals(event.id)) {
            this.events.push(new EntityEvent(this.entity, event.id, event.message));
        }
    }

    @Override
    public void writeFile(PrintWriter writer) {
        writer.print("Entity:  (" + this.entity.getClass().getSimpleName() + ")");
        Entity entity = this.entity;
        if (entity instanceof MobAccessor) {
            MobAccessor mob = (MobAccessor)entity;
            for (WrappedGoal goal : mob.getGoalSelector().getAvailableGoals().stream().filter(WrappedGoal::isRunning).toList()) {
                writer.println("Running Goal: " + goal.getGoal().getClass().getSimpleName());
            }
        }
        for (EntityEvent event : this.events) {
            writer.println(event.toString());
        }
    }
}

