/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.BaseSchematicScreen;
import com.hollingsworth.nuggets.client.area_capture.RenderStructureHandler;
import com.hollingsworth.nuggets.client.area_capture.StructureRenderData;
import com.hollingsworth.nuggets.client.area_capture.ToolType;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;

public class PlaceSchematicScreen
extends BaseSchematicScreen {
    public RenderStructureHandler renderStructureHandler;
    public PlaceTool placeTool;
    public RotateTool rotateTool;
    public MoveHorizontalTool moveHorizontalTool;
    public MoveVerticalTool moveVerticalTool;
    public ConfirmTool confirmTool;
    public PrintTool printTool;
    public DeleteTool deleteTool;
    public MirrorTool mirrorTool;

    public PlaceSchematicScreen(String modId, KeyMapping focusKey, RenderStructureHandler<?> renderStructureHandler) {
        super(modId, focusKey, (Component)Component.literal((String)"Tool Selection"));
        this.renderStructureHandler = renderStructureHandler;
        this.placeTool = new PlaceTool(() -> renderStructureHandler.placingData, this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_place.png"));
        this.rotateTool = new RotateTool(() -> renderStructureHandler.placingData, this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_rotate.png"));
        this.moveHorizontalTool = new MoveHorizontalTool(() -> renderStructureHandler.placingData, this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_horizontal.png"));
        this.moveVerticalTool = new MoveVerticalTool(() -> renderStructureHandler.placingData, this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_vertical.png"));
        this.confirmTool = new ConfirmTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_confirm.png"));
        this.printTool = new PrintTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_print.png"));
        this.deleteTool = new DeleteTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_trash.png"));
        this.mirrorTool = new MirrorTool(() -> renderStructureHandler.placingData, this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_mirror.png"));
        this.tools.add(this.placeTool);
    }

    public void setupManipulationTools() {
        this.tools.clear();
        this.tools.add(this.moveHorizontalTool);
        this.tools.add(this.moveVerticalTool);
        this.tools.add(this.rotateTool);
        this.tools.add(this.confirmTool);
        if (this.renderStructureHandler.onPrint != null) {
            this.tools.add(this.printTool);
        }
        this.tools.add(this.deleteTool);
    }

    public static class PlaceTool
    extends ToolType<PlaceSchematicScreen> {
        public Supplier<StructureRenderData> getStructure;

        public PlaceTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.place_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            StructureRenderData structureData = this.getStructure.get();
            structureData.anchorPos = RaycastHelper.getLookingAt(structureData.distanceFromCameraCast, (Player)Minecraft.getInstance().player, true).getBlockPos();
            ((PlaceSchematicScreen)this.placeSchematicScreen).setupManipulationTools();
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            if (structureData == null) {
                return false;
            }
            structureData.distanceFromCameraCast = delta > 0.0 ? (structureData.distanceFromCameraCast += 1.0) : (structureData.distanceFromCameraCast -= 1.0);
            return true;
        }
    }

    public static class RotateTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public RotateTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.rotate_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            if (structureData == null) {
                return false;
            }
            structureData.rotate(delta > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
            structureData.lastRenderPos = null;
            return true;
        }
    }

    public static class MoveHorizontalTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public MoveHorizontalTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.move_horizontal_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            Direction direction = Minecraft.getInstance().player.getNearestViewDirection();
            BlockPos offset = new BlockPos((int)delta * direction.getStepX(), 0, (int)delta * direction.getStepZ());
            structureData.anchorPos = structureData.anchorPos.offset((Vec3i)offset);
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public MoveVerticalTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.move_vertical_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            if (structureData == null || structureData.anchorPos == null) {
                return false;
            }
            structureData.anchorPos = structureData.anchorPos.offset((Vec3i)new BlockPos(0, (int)delta, 0));
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.move_vertical_description"));
            return list;
        }
    }

    public static class ConfirmTool
    extends ToolType<PlaceSchematicScreen> {
        public ConfirmTool(PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.confirm_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            ((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler.onConfirm.accept(((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.confirm_description"));
            return list;
        }
    }

    public static class PrintTool
    extends ToolType<PlaceSchematicScreen> {
        public PrintTool(PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.print_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            ((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler.onPrint.accept(((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.print_description"));
            return list;
        }
    }

    public static class DeleteTool
    extends ToolType<PlaceSchematicScreen> {
        public DeleteTool(PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.delete_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            ((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler.onDelete.accept(((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.delete_description"));
            return list;
        }
    }

    public static class MirrorTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public MirrorTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.mirror_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            structureData.flip();
            structureData.lastRenderPos = null;
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.mirror_description"));
            return list;
        }
    }
}

