/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.client.area_capture.CaptureSchematicScreen;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import com.hollingsworth.nuggets.common.util.VecHelper;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AreaCaptureHandler {
    public BlockPos firstTarget;
    public BlockPos secondTarget;
    public boolean showBoundary;
    public Direction selectedFace = null;
    BiConsumer<BoundingBox, AreaCaptureHandler> onConfirmedRegion;
    CaptureSchematicScreen captureSchematicScreen;
    private final String modId;
    private final KeyMapping focusKey;
    public BlockPos selectedPos = null;

    public AreaCaptureHandler(String modId, KeyMapping focusKey, BiConsumer<BoundingBox, AreaCaptureHandler> onConfirmedRegion) {
        this.modId = modId;
        this.focusKey = focusKey;
        this.onConfirmedRegion = onConfirmedRegion;
        this.captureSchematicScreen = new CaptureSchematicScreen(modId, focusKey, onConfirmedRegion, this);
    }

    public void rightClickEvent() {
        if (!this.showBoundary) {
            return;
        }
        this.captureSchematicScreen.getSelectedElement().onClick();
    }

    public void toolKeyHit(boolean keyPressed) {
        if (!this.showBoundary) {
            return;
        }
        if (keyPressed && !this.captureSchematicScreen.focused) {
            this.captureSchematicScreen.focused = true;
        }
        if (!keyPressed && this.captureSchematicScreen.focused) {
            this.captureSchematicScreen.focused = false;
            this.captureSchematicScreen.onClose();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.showBoundary) {
            return false;
        }
        return this.captureSchematicScreen.scroll(delta);
    }

    public void renderInstructions(GuiGraphics graphics, Window window) {
        if (!this.showBoundary) {
            return;
        }
        this.captureSchematicScreen.renderPassive(graphics, 0.0f);
    }

    public void startCapture() {
        this.showBoundary = true;
        this.firstTarget = null;
        this.secondTarget = null;
        this.captureSchematicScreen = new CaptureSchematicScreen(this.modId, this.focusKey, this.onConfirmedRegion, this);
    }

    public void cancelCapture() {
        this.showBoundary = false;
        this.firstTarget = null;
        this.secondTarget = null;
    }

    public void renderBoundary(PoseStack poseStack, Matrix4f modelViewMatrix) {
        if (!this.showBoundary) {
            return;
        }
        BlockPos firstPos = this.firstTarget;
        LocalPlayer player = Minecraft.getInstance().player;
        BlockHitResult trace = RaycastHelper.rayTraceRange(player.level(), (Player)player, 75.0);
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockPos hit = trace.getBlockPos();
            boolean replaceable = player.level().getBlockState(hit).canBeReplaced(new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, trace)));
            if (trace.getDirection().getAxis().isVertical() && !replaceable) {
                hit = hit.relative(trace.getDirection());
            }
            this.selectedPos = hit;
        } else {
            this.selectedPos = null;
        }
        if (firstPos == null && this.selectedPos != null) {
            this.renderBbox(new AABB(this.selectedPos), poseStack, modelViewMatrix);
            return;
        }
        BlockPos secondPos = this.secondTarget;
        if (secondPos == null) {
            secondPos = this.selectedPos;
        }
        AABB currentSelectionBox = null;
        currentSelectionBox = secondPos == null ? (firstPos == null ? (this.selectedPos == null ? null : new AABB(this.selectedPos)) : (this.selectedPos == null ? new AABB(firstPos) : AABB.encapsulatingFullBlocks((BlockPos)firstPos, (BlockPos)this.selectedPos).expandTowards(1.0, 1.0, 1.0))) : AABB.encapsulatingFullBlocks((BlockPos)firstPos, (BlockPos)secondPos).expandTowards(1.0, 1.0, 1.0);
        this.renderBbox(currentSelectionBox, poseStack, modelViewMatrix);
    }

    public void renderBbox(AABB currentSelectionBox, PoseStack poseStack, Matrix4f modelViewMatrix) {
        if (currentSelectionBox == null) {
            return;
        }
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        currentSelectionBox.move(camera.scale(-1.0));
        currentSelectionBox = currentSelectionBox.move(-camera.x, -camera.y, -camera.z);
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        VertexConsumer vertexconsumer = NuggetClientData.bufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (AABB)currentSelectionBox, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        NuggetClientData.bufferSource.endBatch();
        poseStack.popPose();
    }

    public void tick() {
        if (!this.showBoundary) {
            return;
        }
        this.captureSchematicScreen.update();
        this.selectedFace = null;
        if (this.secondTarget != null) {
            Vec3 projectedView;
            LocalPlayer player = Minecraft.getInstance().player;
            AABB bb = AABB.encapsulatingFullBlocks((BlockPos)this.firstTarget, (BlockPos)this.secondTarget).expandTowards(1.0, 1.0, 1.0).inflate((double)0.45f);
            boolean inside = bb.contains(projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((Player)player, 70.0, pos -> inside ^ bb.contains(VecHelper.getCenterOf((Vec3i)pos)));
            this.selectedFace = result.missed() ? null : (inside ? result.getFacing().getOpposite() : result.getFacing());
        }
    }
}

