/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public class AABBHelpers {
    public static double boxDistance(AABB box1, AABB box2) {
        double x = Math.max(0.0, Math.max(box1.minX - box2.maxX, box2.minX - box1.maxX));
        double y = Math.max(0.0, Math.max(box1.minY - box2.maxY, box2.minY - box1.maxY));
        double z = Math.max(0.0, Math.max(box1.minZ - box2.maxZ, box2.minZ - box1.maxZ));
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static Iterable<BlockPos> iterateAABB(@Nullable AABB pAabb) {
        if (pAabb == null) {
            return List.of();
        }
        return BlockPos.betweenClosed((int)Mth.floor((double)pAabb.minX), (int)Mth.floor((double)pAabb.minY), (int)Mth.floor((double)pAabb.minZ), (int)Mth.floor((double)pAabb.maxX), (int)Mth.floor((double)pAabb.maxY), (int)Mth.floor((double)pAabb.maxZ));
    }
}

