/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.rendering;

import com.hollingsworth.nuggets.client.Color;
import com.hollingsworth.nuggets.client.rendering.TintedVertexConsumer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderHelpers {
    private static final RenderType TRANSLUCENT = RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
    private static final Matrix4f SCALE_INVERT_Y = new Matrix4f().scaling(1.0f, -1.0f, 1.0f);

    public static void drawItemAsIcon(ItemStack itemStack, GuiGraphics graphics, int positionX, int positionY, int size, boolean renderTransparent) {
        RenderHelpers.renderFakeItemTransparent(graphics.pose(), itemStack, positionX, positionY, size, 0, renderTransparent, 150);
    }

    public static void renderFakeItemTransparent(PoseStack poseStack, ItemStack stack, int x, int y, int scale, int alpha, boolean transparent, int zIndex) {
        if (stack.isEmpty()) {
            return;
        }
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = renderer.getModel(stack, null, (LivingEntity)Minecraft.getInstance().player, 0);
        RenderHelpers.renderItemModel(poseStack, stack, x, y, scale, alpha, model, renderer, transparent, zIndex);
    }

    public static void renderItemModel(PoseStack poseStack, ItemStack stack, int x, int y, int scale, int alpha, BakedModel model, ItemRenderer renderer, boolean transparent, int zIndex) {
        boolean flatLight;
        poseStack.pushPose();
        poseStack.translate((float)x + 8.0f, (float)y + 8.0f, (float)zIndex);
        poseStack.mulPose(SCALE_INVERT_Y);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        boolean bl = flatLight = !model.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        renderer.render(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)(transparent ? RenderHelpers.transparentBuffer((MultiBufferSource)buffer) : buffer), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        poseStack.popPose();
    }

    private static MultiBufferSource transparentBuffer(MultiBufferSource buffer) {
        return renderType -> new TintedVertexConsumer(buffer.getBuffer(TRANSLUCENT), 1.0f, 1.0f, 1.0f, 0.25f);
    }

    public static void colorBlit(PoseStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, Color color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Matrix4f matrix = mStack.last().pose();
        int maxX = x + width;
        int maxY = y + height;
        float minU = (float)uOffset / (float)textureWidth;
        float minV = (float)vOffset / (float)textureHeight;
        float maxU = minU + (float)width / (float)textureWidth;
        float maxV = minV + (float)height / (float)textureHeight;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix, (float)x, (float)maxY, 0.0f).setUv(minU, maxV).setColor(r, g, b, alpha);
        bufferbuilder.addVertex(matrix, (float)maxX, (float)maxY, 0.0f).setUv(maxU, maxV).setColor(r, g, b, alpha);
        bufferbuilder.addVertex(matrix, (float)maxX, (float)y, 0.0f).setUv(maxU, minV).setColor(r, g, b, alpha);
        bufferbuilder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(minU, minV).setColor(r, g, b, alpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void renderTooltipInternal(GuiGraphics graphics, List<ClientTooltipComponent> pClientTooltipComponents, int pMouseX, int pMouseY, Screen parentScreen) {
        Font font = Minecraft.getInstance().font;
        int parentWidth = parentScreen.width;
        int parentHeight = parentScreen.height;
        if (!pClientTooltipComponents.isEmpty()) {
            PoseStack pPoseStack = graphics.pose();
            int i = 0;
            int j = pClientTooltipComponents.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : pClientTooltipComponents) {
                int k = clienttooltipcomponent.getWidth(font);
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.getHeight();
            }
            int j2 = pMouseX + 12;
            int k2 = pMouseY - 12;
            if (j2 + i > parentWidth) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > parentHeight) {
                k2 = parentHeight - j - 6;
            }
            pPoseStack.pushPose();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f matrix4f = pPoseStack.last().pose();
            int backgroundColor = -267386864;
            int borderStart = 0x505000FF;
            int borderEnd = 1344798847;
            graphics.fillGradient(j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 400, backgroundColor, backgroundColor);
            graphics.fillGradient(j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 400, backgroundColor, backgroundColor);
            graphics.fillGradient(j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.fillGradient(j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.fillGradient(j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.fillGradient(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 400, borderStart, borderEnd);
            graphics.fillGradient(j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 400, borderStart, borderEnd);
            graphics.fillGradient(j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 400, borderStart, borderStart);
            graphics.fillGradient(j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 400, borderEnd, borderEnd);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            MultiBufferSource.BufferSource multibuffersource$buffersource = graphics.bufferSource();
            pPoseStack.translate(0.0, 0.0, 400.0);
            int l1 = k2;
            for (int i2 = 0; i2 < pClientTooltipComponents.size(); ++i2) {
                ClientTooltipComponent clienttooltipcomponent1 = pClientTooltipComponents.get(i2);
                clienttooltipcomponent1.renderText(font, j2, l1, matrix4f, multibuffersource$buffersource);
                l1 += clienttooltipcomponent1.getHeight() + (i2 == 0 ? 2 : 0);
            }
            l1 = k2;
            pPoseStack.translate(0.0f, 0.0f, 600.0f);
            for (int l2 = 0; l2 < pClientTooltipComponents.size(); ++l2) {
                ClientTooltipComponent clienttooltipcomponent2 = pClientTooltipComponents.get(l2);
                clienttooltipcomponent2.renderImage(font, j2, l1, graphics);
                l1 += clienttooltipcomponent2.getHeight() + (l2 == 0 ? 2 : 0);
            }
            pPoseStack.popPose();
        }
    }
}

