/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.ToolType;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BaseSchematicScreen
extends Screen {
    public final String holdToFocus = "nuggets.gui.toolmenu.focusKey";
    public String modId;
    public KeyMapping focusKey;
    public List<ToolType> tools = new ArrayList<ToolType>();
    public boolean focused;
    protected float yOffset;
    protected int selection;
    protected boolean initialized;
    protected int w;
    protected int h;

    protected BaseSchematicScreen(String modId, KeyMapping focusKey, Component pTitle) {
        super(pTitle);
        this.minecraft = Minecraft.getInstance();
        this.modId = modId;
        this.focusKey = focusKey;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        this.h = 34;
    }

    public ToolType getSelectedElement() {
        return this.tools.get(this.selection);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(GuiGraphics graphics, float partialTicks) {
        int cellW = 50;
        int padX = 14;
        int minW = 260;
        int count = this.tools.size();
        int rowW = count * 50;
        this.w = Math.max(rowW + 28, 260);
        PoseStack matrixStack = graphics.pose();
        Window mainWindow = this.minecraft.getWindow();
        if (!this.initialized) {
            this.init(this.minecraft, mainWindow.getGuiScaledWidth(), mainWindow.getGuiScaledHeight());
        }
        int panelX = (mainWindow.getGuiScaledWidth() - this.w) / 2;
        int y = mainWindow.getGuiScaledHeight() - this.h - 34;
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)"textures/gui/hud_background.png"), panelX - 15 + 14, y, 0.0f, 0.0f, this.w, this.h, 16, 16);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        if (toolTipAlpha > 0.25f) {
            graphics.blit(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)"textures/gui/hud_background.png"), panelX - 15 + 14, y + 32, 0.0f, 0.0f, this.w, this.h, 16, 16);
            if (!toolTip.isEmpty()) {
                GuiHelpers.drawOutlinedText(this.minecraft.font, graphics, toolTip.get(0), panelX + 10, y + 38);
            }
            if (toolTip.size() > 1) {
                GuiHelpers.drawOutlinedText(this.minecraft.font, graphics, toolTip.get(1), panelX + 10, y + 50);
            }
        }
        int width = this.minecraft.getWindow().getGuiScaledWidth();
        String keyName = this.focusKey.getTranslatedKeyMessage().getString();
        if (!this.focused) {
            GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"nuggets.gui.toolmenu.focusKey", (Object[])new Object[]{keyName}), width / 2, y - 10);
        } else {
            GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"nuggets.scroll"), width / 2, y - 10);
        }
        int startX = panelX + Math.max(14, (this.w - rowW) / 2);
        for (int i = 0; i < count; ++i) {
            matrixStack.pushPose();
            int cellX = startX + i * 50;
            if (i == this.selection) {
                matrixStack.translate(0.0f, -10.0f, 0.0f);
                GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, this.tools.get(i).getDisplayName(), cellX + 26, y + 28);
            }
            ResourceLocation icon = this.tools.get(i).getIcon();
            graphics.blit(icon, cellX + 16, y + 11, 0.0f, 0.0f, 16, 16, 16, 16);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public boolean scroll(double delta) {
        if (this.focused) {
            this.cycle((int)delta);
            return true;
        }
        if (BaseSchematicScreen.hasControlDown()) {
            return this.tools.get(this.selection).handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(GuiGraphics graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void onClose() {
    }

    protected void init() {
        super.init();
        this.initialized = true;
    }
}

