/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.inventory;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;

public class SlotCache {
    protected LoadingCache<Item, IntRBTreeSet> cache;

    public SlotCache() {
        this(true);
    }

    public SlotCache(boolean shouldExpire) {
        this.cache = shouldExpire ? CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(30L, TimeUnit.MINUTES).build(CacheLoader.from(key -> new IntRBTreeSet())) : CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(key -> new IntRBTreeSet()));
    }

    public Collection<Integer> getOrCreateSlots(Item item) {
        return (Collection)this.cache.getUnchecked((Object)item);
    }

    @Nullable
    public Collection<Integer> getIfPresent(Item item) {
        return (Collection)this.cache.getIfPresent((Object)item);
    }

    public void replaceSlotWithItem(Item extracted, Item newItem, int slot) {
        ((IntRBTreeSet)this.cache.getUnchecked((Object)extracted)).remove(slot);
        ((IntRBTreeSet)this.cache.getUnchecked((Object)newItem)).add(slot);
    }

    public String toString() {
        return "SlotCache{cache=" + String.valueOf(this.cache.asMap()) + "}";
    }
}

