/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.rendering;

import com.hollingsworth.nuggets.client.rendering.TagPos;
import com.hollingsworth.nuggets.common.util.ItemStackKey;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class StatePos {
    public static StreamCodec<RegistryFriendlyByteBuf, StatePos> STREAM = StreamCodec.ofMember((val, buf) -> {
        ByteBufCodecs.COMPOUND_TAG.encode(buf, (Object)val.tag);
        BlockPos.STREAM_CODEC.encode(buf, (Object)val.pos);
    }, buf -> new StatePos((CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode(buf), (BlockPos)BlockPos.STREAM_CODEC.decode(buf)));
    public static StreamCodec<RegistryFriendlyByteBuf, List<StatePos>> STREAM_LIST = STREAM.apply(ByteBufCodecs.list());
    public BlockState state;
    public BlockPos pos;
    private CompoundTag tag;

    public StatePos(BlockState state, BlockPos pos) {
        this.state = state;
        this.pos = pos;
    }

    public StatePos(CompoundTag tag, BlockPos pos) {
        this.state = null;
        this.tag = tag;
        this.pos = pos;
    }

    public static List<BlockState> getBlockStateMap(List<StatePos> list) {
        ArrayList<BlockState> blockStateMap = new ArrayList<BlockState>();
        for (StatePos statePos : list) {
            if (blockStateMap.contains(statePos.state)) continue;
            blockStateMap.add(statePos.state);
        }
        return blockStateMap;
    }

    public static List<StatePos> rotate(List<StatePos> list, List<TagPos> tagListMutable, Rotation rotation) {
        ArrayList<StatePos> rotatedList = new ArrayList<StatePos>();
        if (list == null || list.isEmpty()) {
            return rotatedList;
        }
        boolean tags = tagListMutable != null && !tagListMutable.isEmpty();
        Map<Object, Object> tagMap = new HashMap();
        if (tags) {
            tagMap = tagListMutable.stream().collect(Collectors.toMap(e -> e.pos, e -> e.tag));
        }
        for (StatePos statePos : list) {
            BlockPos oldPos = statePos.pos;
            BlockState oldState = statePos.state;
            BlockState newState = oldState.rotate(rotation);
            BlockPos newPos = oldPos.rotate(rotation);
            if (tags && tagMap.get(statePos.pos) != null) {
                CompoundTag tempTag = (CompoundTag)tagMap.get(statePos.pos);
                tagMap.remove(statePos.pos);
                tagMap.put(newPos, tempTag);
            }
            rotatedList.add(new StatePos(newState, newPos));
        }
        if (tags) {
            tagListMutable.clear();
            for (Map.Entry entry : tagMap.entrySet()) {
                tagListMutable.add(new TagPos((CompoundTag)entry.getValue(), (BlockPos)entry.getKey()));
            }
        }
        return rotatedList;
    }

    public static ListTag getBlockStateNBT(List<BlockState> blockStateMap) {
        ListTag listTag = new ListTag();
        for (BlockState blockState : blockStateMap) {
            listTag.add((Object)NbtUtils.writeBlockState((BlockState)blockState));
        }
        return listTag;
    }

    public static List<BlockState> getBlockStateMapFromNBT(ListTag listTag) {
        ArrayList<BlockState> blockStateMap = new ArrayList<BlockState>();
        for (int i = 0; i < listTag.size(); ++i) {
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)listTag.getCompound(i));
            blockStateMap.add(blockState);
        }
        return blockStateMap;
    }

    public static Map<ItemStackKey, Integer> getItemList(ArrayList<StatePos> list) {
        Object2IntOpenHashMap itemList = new Object2IntOpenHashMap();
        if (list == null || list.isEmpty()) {
            return itemList;
        }
        for (StatePos statePos : list) {
            BlockPos blockPos = BlockPos.ZERO;
            ClientLevel level = Minecraft.getInstance().level;
            ItemStack cloneStack = statePos.state.getBlock().getCloneItemStack((LevelReader)level, blockPos, statePos.state);
            ItemStackKey itemStackKey = new ItemStackKey(cloneStack, true);
            if (!itemList.containsKey(itemStackKey)) {
                itemList.put(itemStackKey, 1);
                continue;
            }
            itemList.put(itemStackKey, (Integer)itemList.get(itemStackKey) + 1);
        }
        return itemList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatePos) {
            return ((StatePos)obj).state.equals(this.state) && ((StatePos)obj).pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.state, this.pos);
    }
}

