/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.AreaCaptureHandler;
import com.hollingsworth.nuggets.client.area_capture.BaseSchematicScreen;
import com.hollingsworth.nuggets.client.area_capture.ToolType;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CaptureSchematicScreen
extends BaseSchematicScreen {
    public AreaCaptureHandler areaCaptureHandler;
    public SelectPositionTool selectPositionTool;
    public HorizontalMoveTool horizontalMoveTool;
    public VerticalMoveTool verticalMoveTool;
    public ExpandTool expandTool;
    public ConfirmTool confirmTool;
    public CancelTool cancelTool;
    public BiConsumer<BoundingBox, AreaCaptureHandler> onConfirmed;

    protected CaptureSchematicScreen(String modId, KeyMapping focusKey, BiConsumer<BoundingBox, AreaCaptureHandler> onConfirmed, AreaCaptureHandler areaCaptureHandler) {
        super(modId, focusKey, (Component)Component.literal((String)"Capture Schematic Screen"));
        this.areaCaptureHandler = areaCaptureHandler;
        this.onConfirmed = onConfirmed;
        this.selectPositionTool = new SelectPositionTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_place.png"));
        this.horizontalMoveTool = new HorizontalMoveTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_horizontal.png"));
        this.verticalMoveTool = new VerticalMoveTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_vertical.png"));
        this.expandTool = new ExpandTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_resize.png"));
        this.confirmTool = new ConfirmTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_icon_confirm.png"));
        this.cancelTool = new CancelTool(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/visualizer_trash.png"));
        this.tools.add(this.selectPositionTool);
        this.tools.add(this.cancelTool);
    }

    public void onBoundarySet() {
        this.tools.clear();
        this.tools.add(this.horizontalMoveTool);
        this.tools.add(this.verticalMoveTool);
        this.tools.add(this.expandTool);
        this.tools.add(this.confirmTool);
        this.tools.add(this.cancelTool);
    }

    public static class SelectPositionTool
    extends ToolType<CaptureSchematicScreen> {
        public SelectPositionTool(CaptureSchematicScreen captureSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.place_tool"), icon, captureSchematicScreen);
        }

        @Override
        public void onClick() {
            AreaCaptureHandler captureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            BlockPos pos = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler.selectedPos;
            if (pos == null) {
                return;
            }
            if (captureHandler.firstTarget == null) {
                captureHandler.firstTarget = pos.immutable();
            } else if (captureHandler.secondTarget == null && !captureHandler.firstTarget.equals((Object)pos)) {
                captureHandler.secondTarget = pos.immutable();
                ((CaptureSchematicScreen)this.placeSchematicScreen).onBoundarySet();
            }
        }

        @Override
        List<Component> getDescription() {
            return List.of(Component.translatable((String)"nuggets.select_position_tool_description"));
        }
    }

    public static class HorizontalMoveTool
    extends ToolType<CaptureSchematicScreen> {
        public HorizontalMoveTool(CaptureSchematicScreen captureSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.move_horizontal_tool"), icon, captureSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            if (delta > 0.0) {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.east();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.east();
            } else {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.west();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.west();
            }
            return true;
        }

        @Override
        public List<Component> getDescription() {
            return List.of(Component.translatable((String)"nuggets.move_horizontal_description"));
        }
    }

    public static class VerticalMoveTool
    extends ToolType<CaptureSchematicScreen> {
        public VerticalMoveTool(CaptureSchematicScreen captureSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.move_vertical_tool"), icon, captureSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            if (delta > 0.0) {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.above();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.above();
            } else {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.below();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.below();
            }
            return true;
        }

        @Override
        public List<Component> getDescription() {
            return List.of(Component.translatable((String)"nuggets.move_vertical_description"));
        }
    }

    public static class ExpandTool
    extends ToolType<CaptureSchematicScreen> {
        public ExpandTool(CaptureSchematicScreen captureSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.expand_tool"), icon, captureSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            boolean showBoundary = areaCaptureHandler.showBoundary;
            BlockPos firstTarget = areaCaptureHandler.firstTarget;
            BlockPos secondTarget = areaCaptureHandler.secondTarget;
            Direction selectedFace = areaCaptureHandler.selectedFace;
            if (!showBoundary || firstTarget == null || secondTarget == null) {
                return false;
            }
            if (!Screen.hasControlDown()) {
                return false;
            }
            if (selectedFace == null) {
                return true;
            }
            AABB bb = new AABB((double)firstTarget.getX(), (double)firstTarget.getY(), (double)firstTarget.getZ(), (double)secondTarget.getX(), (double)secondTarget.getY(), (double)secondTarget.getZ());
            Vec3i vec = selectedFace.getNormal();
            Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            if (bb.contains(projectedView)) {
                delta *= -1.0;
            }
            int x = (int)((double)vec.getX() * delta);
            int y = (int)((double)vec.getY() * delta);
            int z = (int)((double)vec.getZ() * delta);
            Direction.AxisDirection axisDirection = selectedFace.getAxisDirection();
            if (axisDirection == Direction.AxisDirection.NEGATIVE) {
                bb = bb.move((double)(-x), (double)(-y), (double)(-z));
            }
            double maxX = Math.max(bb.maxX - (double)(x * axisDirection.getStep()), bb.minX);
            double maxY = Math.max(bb.maxY - (double)(y * axisDirection.getStep()), bb.minY);
            double maxZ = Math.max(bb.maxZ - (double)(z * axisDirection.getStep()), bb.minZ);
            bb = new AABB(bb.minX, bb.minY, bb.minZ, maxX, maxY, maxZ);
            areaCaptureHandler.firstTarget = BlockPos.containing((double)bb.minX, (double)bb.minY, (double)bb.minZ);
            areaCaptureHandler.secondTarget = BlockPos.containing((double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
            return true;
        }

        @Override
        List<Component> getDescription() {
            return List.of(Component.translatable((String)"nuggets.expand_tool.description"), Component.translatable((String)"nuggets.expand_tool.description2"));
        }
    }

    public static class ConfirmTool
    extends ToolType<CaptureSchematicScreen> {
        public ConfirmTool(CaptureSchematicScreen captureSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.confirm_tool_capture"), icon, captureSchematicScreen);
        }

        @Override
        public void onClick() {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            areaCaptureHandler.showBoundary = false;
            if (areaCaptureHandler.firstTarget != null && areaCaptureHandler.secondTarget != null) {
                ((CaptureSchematicScreen)this.placeSchematicScreen).onConfirmed.accept(BoundingBox.fromCorners((Vec3i)areaCaptureHandler.firstTarget, (Vec3i)areaCaptureHandler.secondTarget), areaCaptureHandler);
            }
        }

        @Override
        List<Component> getDescription() {
            return List.of(Component.translatable((String)"nuggets.capture_confirm_tool"));
        }
    }

    public static class CancelTool
    extends ToolType<CaptureSchematicScreen> {
        public CancelTool(CaptureSchematicScreen captureSchematicScreen, ResourceLocation icon) {
            super((Component)Component.translatable((String)"nuggets.delete_tool"), icon, captureSchematicScreen);
        }

        @Override
        public void onClick() {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            areaCaptureHandler.cancelCapture();
        }

        @Override
        List<Component> getDescription() {
            return List.of(Component.translatable((String)"nuggets.delete_description"));
        }
    }
}

