/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.registry;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class RegistryWrapper<R, T extends R>
implements Supplier<T>,
ItemLike {
    public DeferredHolder<R, T> registryObject;

    public RegistryWrapper(DeferredHolder<R, T> registryObject) {
        this.registryObject = registryObject;
    }

    @Override
    @NotNull
    public T get() {
        return (T)this.registryObject.get();
    }

    public Item asItem() {
        Object object = this.registryObject.get();
        if (object instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)object;
            return itemLike.asItem();
        }
        throw new IllegalStateException("RegistryWrapper is not an Item");
    }

    public Holder<R> getHolder() {
        return this.registryObject.getDelegate();
    }

    public ResourceLocation getResourceLocation() {
        return this.registryObject.getId();
    }

    public String getRegistryName() {
        return this.registryObject.getId().getPath();
    }

    public BlockState defaultBlockState() {
        Object object = this.registryObject.get();
        if (object instanceof Block) {
            Block block = (Block)object;
            return block.defaultBlockState();
        }
        throw new IllegalStateException("RegistryWrapper is not a Block");
    }
}

