/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.gui.CopyEditBox;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class NoShadowTextField
extends CopyEditBox {
    public Function<String, Void> onClear;

    public NoShadowTextField(Font p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, Component p_i232260_6_) {
        super(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, p_i232260_6_);
        this.textColor = -8355712;
    }

    public NoShadowTextField(Font p_i232259_1_, int p_i232259_2_, int p_i232259_3_, int p_i232259_4_, int p_i232259_5_, @Nullable EditBox p_i232259_6_, Component p_i232259_7_) {
        super(p_i232259_1_, p_i232259_2_, p_i232259_3_, p_i232259_4_, p_i232259_5_, p_i232259_6_, p_i232259_7_);
        this.textColor = -8355712;
    }

    public int getXTextOffset() {
        return this.bordered ? this.getX() + 4 : this.getX();
    }

    public int getYTextOffset() {
        return this.bordered ? this.getY() + (this.height - 8) / 2 : this.getY();
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int i2 = this.isEditable ? this.textColor : this.textColorUneditable;
            int adjustedCursorPos = this.cursorPos - this.displayPos;
            String displayValue = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean flag = adjustedCursorPos >= 0 && adjustedCursorPos <= displayValue.length();
            boolean flag1 = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && flag;
            int xOffset = this.getXTextOffset();
            int yOffset = this.getYTextOffset();
            int xOffsetCopy = xOffset;
            if (!displayValue.isEmpty()) {
                String s1 = flag ? displayValue.substring(0, adjustedCursorPos) : displayValue;
                xOffsetCopy = graphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(s1, this.displayPos), xOffset, yOffset, this.textColor, false);
            }
            boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= 32;
            int k1 = xOffsetCopy;
            if (!flag) {
                k1 = adjustedCursorPos > 0 ? xOffset + this.width : xOffset;
            } else if (flag2) {
                k1 = xOffsetCopy - 1;
                --xOffsetCopy;
            }
            if (!displayValue.isEmpty() && flag && adjustedCursorPos < displayValue.length()) {
                graphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(displayValue.substring(adjustedCursorPos), this.cursorPos), xOffsetCopy, yOffset, i2);
            }
            if (this.value.isEmpty() && !flag2 && this.suggestion != null) {
                graphics.drawString(this.font, this.suggestion, k1, yOffset, this.textColor, false);
            }
            if (flag1) {
                if (flag2) {
                    graphics.fill(k1, yOffset - 1, k1 + 1, yOffset + 1 + 9, -3092272);
                } else {
                    graphics.drawString(this.font, "_", k1, yOffset, i2, false);
                }
            }
        }
    }

    public boolean mouseClicked(double clickedX, double clickedY, int mouseButton) {
        boolean clickedThis;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = clickedThis = clickedX >= (double)this.getX() && clickedX < (double)(this.getX() + this.width) && clickedY >= (double)this.getY() && clickedY < (double)(this.getY() + this.height);
        if (this.canLoseFocus) {
            this.setFocused(clickedThis);
        }
        if (this.isFocused() && clickedThis && mouseButton == 0) {
            int i = Mth.floor((double)clickedX) - this.getX();
            if (this.bordered) {
                i -= 4;
            }
            String s = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.plainSubstrByWidth(s, i).length() + this.displayPos, true);
            return true;
        }
        if (this.isFocused() && mouseButton == 1) {
            if (this.value.isEmpty()) {
                return clickedThis;
            }
            if (this.onClear != null) {
                this.onClear.apply("");
            }
            this.setValue("");
            return clickedThis;
        }
        return false;
    }
}

