/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.util;

import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockPosHelpers {
    public static final BiPredicate<BlockGetter, BlockPos> TWO_HIGH_AIR_POS_SELECTOR = (world, pos) -> (world.getBlockState(pos).canOcclude() || world.getBlockState(pos).liquid()) && world.getBlockState(pos.above()).isAir() && world.getBlockState(pos.above(2)).isAir();

    private static BlockPos findSpawnPointInDirections(Level level, BlockPos start, BlockPos advancePos) {
        BlockPos spawnPos = new BlockPos((Vec3i)start);
        Vec3 tempPos = new Vec3((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ());
        int xDiff = Math.abs(start.getX() - advancePos.getX());
        int zDiff = Math.abs(start.getZ() - advancePos.getZ());
        Vec3 xzRatio = new Vec3((double)(xDiff * (start.getX() < advancePos.getX() ? 1 : -1)), 0.0, (double)(zDiff * (start.getZ() < advancePos.getZ() ? 1 : -1)));
        xzRatio = xzRatio.normalize().scale(3.0);
        int validChunkCount = 0;
        for (int i = 0; i < 10 && level.isLoaded(BlockPos.containing((Position)tempPos)) && level.isLoaded(BlockPos.containing((Position)(tempPos = tempPos.add(16.0 * xzRatio.x, 0.0, 16.0 * xzRatio.z)))); ++i) {
            spawnPos = BlockPos.containing((Position)tempPos);
            if (++validChunkCount <= 5) continue;
            return spawnPos;
        }
        if (!spawnPos.equals((Object)start)) {
            return spawnPos;
        }
        return null;
    }

    public static BlockPos getRandomSpawn(BlockPos calcCenter, Level level) {
        int degree = level.random.nextInt(360);
        int x = (int)Math.round(20.0 * Math.cos(Math.toRadians(degree)));
        int z = (int)Math.round(20.0 * Math.sin(Math.toRadians(degree)));
        BlockPos advanceTowards = calcCenter.offset(x, 0, z);
        BlockPos spawnPos = null;
        for (int i = 0; i < 8 && (spawnPos = BlockPosHelpers.findSpawnPointInDirections(level, new BlockPos(calcCenter.getX(), calcCenter.getY(), calcCenter.getZ()), advanceTowards)) == null; ++i) {
        }
        if (spawnPos == null) {
            return null;
        }
        return BlockPosHelpers.findAround(level, BlockPosHelpers.getFloor(spawnPos, level), 3, 30, TWO_HIGH_AIR_POS_SELECTOR);
    }

    @NotNull
    public static BlockPos getFloor(@NotNull BlockPos position, @NotNull Level world) {
        BlockPos floor = BlockPosHelpers.getFloor(new BlockPos.MutableBlockPos(position.getX(), position.getY(), position.getZ()), 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }

    @Nullable
    public static BlockPos getFloor(BlockPos.MutableBlockPos position, int depth, @NotNull Level world) {
        if (!BlockPosHelpers.solidOrLiquid(world, (BlockPos)position)) {
            return BlockPosHelpers.getFloor(position.set(position.getX(), position.getY() - 1, position.getZ()), depth + 1, world);
        }
        if (!BlockPosHelpers.solidOrLiquid(world, (BlockPos)position.set(position.getX(), position.getY() + 1, position.getZ())) && !BlockPosHelpers.solidOrLiquid(world, (BlockPos)position.set(position.getX(), position.getY() + 2, position.getZ()))) {
            return position.immutable();
        }
        return BlockPosHelpers.getFloor(position.set(position.getX(), position.getY() + 1, position.getZ()), depth + 1, world);
    }

    public static boolean solidOrLiquid(@NotNull Level world, @NotNull BlockPos blockPos) {
        BlockState state = world.getBlockState(blockPos);
        return state.isAir() || state.liquid();
    }

    public static BlockPos findAround(Level world, BlockPos start, int verticalRange, int horizontalRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        if (predicate.test((BlockGetter)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.offset(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (BlockPosHelpers.isInWorldHeight(start.getY() + (y += (y_offset *= -1)), world)) continue;
            return null;
        }
        return null;
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.dimensionType();
        return yBlock > BlockPosHelpers.getDimensionMinHeight(dimensionType) && yBlock < BlockPosHelpers.getDimensionMaxHeight(dimensionType);
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.logicalHeight() + dimensionType.minY();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.minY();
    }

    public static double distanceBetween(BlockPos blockPos, BlockPos blockPos2) {
        return Math.sqrt(Math.pow(blockPos.getX() - blockPos2.getX(), 2.0) + Math.pow(blockPos.getY() - blockPos2.getY(), 2.0) + Math.pow(blockPos.getZ() - blockPos2.getZ(), 2.0));
    }
}

