/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.BlitInfo;
import com.hollingsworth.nuggets.client.gui.BaseSlider;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class VerticalSlider
extends BaseSlider {
    public Consumer<Integer> onChange;
    public BlitInfo scrollBar;
    public BlitInfo scrollContainer;

    public VerticalSlider(int x, int y, int width, int height, BlitInfo scrollBar, BlitInfo scrollContainer, double maxValue, double stepSize, int precision, Consumer<Integer> onChange) {
        super(x, y, width, height, (Component)Component.empty(), (Component)Component.empty(), 0.0, maxValue, 0.0, stepSize, precision, false);
        this.onChange = onChange;
        this.scrollBar = scrollBar;
        this.scrollContainer = scrollContainer;
    }

    public VerticalSlider(int x, int y, int width, int height, BlitInfo scrollBar, BlitInfo scrollContainer, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, drawString);
        this.scrollBar = scrollBar;
        this.scrollContainer = scrollContainer;
    }

    @Override
    protected void applyValue() {
        super.applyValue();
        this.onChange.accept(this.getValueInt());
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        GuiHelpers.blit(guiGraphics, this.scrollContainer, this.getX(), this.getY());
        GuiHelpers.blit(guiGraphics, this.scrollBar, this.getX() + 3, this.getY() + (int)(this.value * (double)(this.height - 3)));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY != 0.0) {
            this.setValue(this.getValue() + (double)(pScrollY > 0.0 ? -1 : 1) * this.stepSize);
            this.applyValue();
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.height - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    @Override
    public void setValueFromMouse(double mouseX, double mouseY) {
        this.setSliderValue((mouseY - (double)(this.getY() + 4)) / (double)(this.height - 8));
    }
}

