/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class WorldHelpers {
    public static StructureTemplate getStructure(Level level, BlockPos first, BlockPos second) {
        BoundingBox bb = BoundingBox.fromCorners((Vec3i)first, (Vec3i)second);
        BlockPos origin = new BlockPos(bb.minX(), bb.minY(), bb.minZ());
        BlockPos bounds = new BlockPos(bb.getXSpan(), bb.getYSpan(), bb.getZSpan());
        StructureTemplate structure = new StructureTemplate();
        structure.fillFromWorld(level, origin, (Vec3i)bounds, true, Blocks.AIR);
        return structure;
    }

    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldHelpers.isChunkLoaded(world, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.getChunkSource() instanceof ServerChunkCache) {
            return ((ServerChunkCache)world.getChunkSource()).getChunkFuture(x, z, ChunkStatus.FULL, false).isDone();
        }
        return world.getChunk(x, z, ChunkStatus.FULL, false) != null;
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        if (WorldHelpers.isBlockLoaded((LevelAccessor)world, pos)) {
            world.getChunk(pos.getX() >> 4, pos.getZ() >> 4).setUnsaved(true);
            BlockState state = world.getBlockState(pos);
            world.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return WorldHelpers.isChunkLoaded(world, pos.x, pos.z);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldHelpers.isEntityChunkLoaded(world, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return WorldHelpers.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return ((ServerLevel)world).isPositionEntityTicking(pos.getWorldPosition());
        }
        return WorldHelpers.isChunkLoaded(world, pos);
    }

    public static boolean isAABBLoaded(Level world, AABB box) {
        return WorldHelpers.isChunkLoaded((LevelAccessor)world, (int)box.minX >> 4, (int)box.minZ >> 4) && WorldHelpers.isChunkLoaded((LevelAccessor)world, (int)box.maxX >> 4, (int)box.maxZ >> 4);
    }

    public static boolean isPastTime(Level world, int pastTime) {
        return world.getDayTime() % 24000L <= (long)pastTime;
    }

    public static boolean isOfWorldType(@NotNull Level world, @NotNull ResourceKey<DimensionType> type) {
        RegistryAccess dynRegistries = world.registryAccess();
        ResourceLocation loc = ((Registry)dynRegistries.registry(Registries.DIMENSION_TYPE).get()).getKey((Object)world.dimensionType());
        if (loc == null) {
            if (world.isClientSide) {
                return world.dimensionType().effectsLocation().equals((Object)type.location());
            }
            return false;
        }
        ResourceKey regKey = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(@NotNull Level world) {
        return !world.getLevelData().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) || world.getDifficulty().equals((Object)Difficulty.PEACEFUL);
    }
}

