/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.inventory;

import com.hollingsworth.nuggets.common.inventory.FilterSet;
import com.hollingsworth.nuggets.common.inventory.InteractResult;
import com.hollingsworth.nuggets.common.inventory.InteractType;
import com.hollingsworth.nuggets.common.inventory.SlotCache;
import com.hollingsworth.nuggets.common.inventory.SortPref;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.IItemHandler;

public class FilterableItemHandler {
    private SlotCache slotCache;
    private IItemHandler handler;
    public FilterSet filters;

    public FilterableItemHandler(IItemHandler handler) {
        this(handler, new FilterSet.ListSet());
    }

    public FilterableItemHandler(IItemHandler handler, List<Function<ItemStack, SortPref>> functions) {
        this(handler, new FilterSet.ListSet(functions));
    }

    public FilterableItemHandler(IItemHandler handler, FilterSet filters) {
        this.handler = handler;
        this.filters = filters;
        this.slotCache = new SlotCache();
    }

    public FilterableItemHandler withSlotCache(SlotCache cache) {
        this.slotCache = cache;
        return this;
    }

    public InteractResult canInsert(ItemStack stack) {
        SortPref pref;
        return new InteractResult(pref, (pref = this.getHighestPreference(stack)) != SortPref.INVALID);
    }

    public InteractResult canExtract(ItemStack stack) {
        SortPref pref;
        return new InteractResult(pref, (pref = this.getHighestPreference(stack)) != SortPref.INVALID);
    }

    public InteractResult canInteractFor(ItemStack stack, InteractType type) {
        return type == InteractType.EXTRACT ? this.canExtract(stack) : this.canInsert(stack);
    }

    public SortPref getHighestPreference(ItemStack stack) {
        return this.filters.getHighestPreference(stack);
    }

    public IItemHandler getHandler() {
        return this.handler;
    }

    public ItemStack insertItemStacked(ItemStack stack, boolean simulate) {
        IItemHandler inventory = this.handler;
        if (inventory == null || stack.isEmpty()) {
            return stack;
        }
        if (!stack.isStackable()) {
            return this.insertItem(stack, simulate);
        }
        int sizeInventory = inventory.getSlots();
        if ((stack = this.insertUsingCache(stack, simulate)).isEmpty()) {
            return stack;
        }
        Collection<Integer> slotsForStack = this.slotCache.getOrCreateSlots(stack.getItem());
        Collection<Integer> emptySlots = this.slotCache.getOrCreateSlots(Items.AIR);
        for (int i = 0; i < sizeInventory; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)stack)) {
                int count = stack.getCount();
                if ((stack = inventory.insertItem(i, stack, simulate)).getCount() != count) {
                    slotsForStack.add(i);
                }
                if (!stack.isEmpty()) continue;
                return stack;
            }
            if (!slot.isEmpty()) continue;
            emptySlots.add(i);
        }
        ArrayList<Integer> invalidSlots = new ArrayList<Integer>();
        for (int slot : emptySlots) {
            if (inventory.getStackInSlot(slot).isEmpty()) {
                if (!(stack = inventory.insertItem(slot, stack, simulate)).isEmpty()) continue;
                break;
            }
            invalidSlots.add(slot);
        }
        for (int slot : invalidSlots) {
            emptySlots.remove(slot);
        }
        return stack;
    }

    private ItemStack insertItem(ItemStack stack, boolean simulate) {
        IItemHandler dest = this.handler;
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        if ((stack = this.insertUsingCache(stack, simulate)).isEmpty()) {
            return stack;
        }
        if ((stack = this.insertInCachedEmptySlots(stack, simulate)).isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item item = stack.getItem();
        for (int i = 0; i < dest.getSlots(); ++i) {
            int count = stack.getCount();
            if ((stack = dest.insertItem(i, stack, simulate)).getCount() != count) {
                this.slotCache.getOrCreateSlots(item).add(i);
            }
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack targetStack = dest.getStackInSlot(i);
            if (!targetStack.isEmpty()) continue;
            this.slotCache.getOrCreateSlots(Items.AIR).add(i);
        }
        return stack;
    }

    private ItemStack insertUsingCache(ItemStack stack, boolean simulate) {
        IItemHandler dest = this.handler;
        Collection<Integer> slots = this.slotCache.getIfPresent(stack.getItem());
        if (slots == null || stack.isEmpty()) {
            return stack;
        }
        ArrayList<Integer> invalidSlots = new ArrayList<Integer>();
        int maxSlots = dest.getSlots();
        for (int slot : slots) {
            if (slot >= maxSlots) {
                invalidSlots.add(slot);
                continue;
            }
            int count = stack.getCount();
            ItemStack targetStack = dest.getStackInSlot(slot);
            if (stack.isStackable() && targetStack.isEmpty()) {
                invalidSlots.add(slot);
                continue;
            }
            if ((stack = dest.insertItem(slot, stack, simulate)).getCount() == count && !ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)stack)) {
                invalidSlots.add(slot);
            }
            if (!stack.isEmpty()) continue;
            break;
        }
        for (int slot : invalidSlots) {
            slots.remove(slot);
        }
        return stack;
    }

    private ItemStack insertInCachedEmptySlots(ItemStack stack, boolean simulate) {
        IItemHandler dest = this.handler;
        Collection<Integer> slots = this.slotCache.getIfPresent(Items.AIR);
        if (slots == null) {
            return stack;
        }
        ArrayList<Integer> invalidSlots = new ArrayList<Integer>();
        int maxSlots = dest.getSlots();
        for (int slot : slots) {
            if (slot >= maxSlots) {
                invalidSlots.add(slot);
                continue;
            }
            int count = stack.getCount();
            if ((stack = dest.insertItem(slot, stack, simulate)).getCount() == count) {
                invalidSlots.add(slot);
            } else if (!dest.getStackInSlot(slot).isEmpty()) {
                this.slotCache.getOrCreateSlots(stack.getItem()).add(slot);
                invalidSlots.add(slot);
            }
            if (!stack.isEmpty()) continue;
            break;
        }
        for (int slot : invalidSlots) {
            slots.remove(slot);
        }
        return stack;
    }
}

