/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.client.gui.BaseButton;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.rendering.RenderHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ItemButton
extends BaseButton {
    public Ingredient ingredient;
    public Screen screen;
    public int scale = 16;

    public ItemButton(int x, int y, int w, int h, @NotNull Component text, Button.OnPress onPress, Ingredient ingredient, Screen screen) {
        super(x, y, w, h, text, onPress);
        this.ingredient = ingredient;
        this.screen = screen;
    }

    public ItemButton(int x, int y, int w, int h, @NotNull Component text, Button.OnPress onPress, ItemStack stack, Screen screen) {
        this(x, y, w, h, text, onPress, Ingredient.of((ItemStack[])new ItemStack[]{stack}), screen);
    }

    public ItemButton withScale(int scale) {
        this.scale = scale;
        return this;
    }

    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.ingredient != null && this.ingredient.getItems().length != 0) {
            ItemStack stack = this.ingredient.getItems()[NuggetClientData.ticksInGame / 20 % this.ingredient.getItems().length];
            RenderHelpers.drawItemAsIcon(stack, graphics, this.getX(), this.getY(), this.scale, false);
        }
    }

    @Override
    public void gatherTooltips(GuiGraphics graphics, int mouseX, int mouseY, List<Component> tooltip) {
        super.gatherTooltips(graphics, mouseX, mouseY, tooltip);
        if (this.ingredient != null && this.ingredient.getItems().length != 0) {
            ItemStack stack = this.ingredient.getItems()[NuggetClientData.ticksInGame / 20 % this.ingredient.getItems().length];
            Font font = Minecraft.getInstance().font;
            ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>(GuiHelpers.gatherTooltipComponents(Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack), mouseX, this.screen.width, this.screen.height, font));
            RenderHelpers.renderTooltipInternal(graphics, components, mouseX, mouseY, this.screen);
        }
    }
}

