/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.BlitInfo;
import com.hollingsworth.nuggets.client.NuggetClientData;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;

public class GuiHelpers {
    public static void blit(GuiGraphics graphics, BlitInfo info, int x, int y) {
        graphics.blit(info.location(), x + info.xOffset(), y + info.yOffset(), (float)info.u(), (float)info.v(), info.width(), info.height(), info.width(), info.height());
    }

    public static void drawOutlinedText(Font font, GuiGraphics graphics, Component component, int x, int y) {
        GuiHelpers.drawOutlinedText(font, graphics, component.getVisualOrderText(), x, y);
    }

    public static void drawOutlinedText(Font font, GuiGraphics graphics, FormattedCharSequence component, int x, int y) {
        font.drawInBatch8xOutline(component, (float)x, (float)y, DyeColor.WHITE.getTextColor(), DyeColor.BLACK.getTextColor(), graphics.pose().last().pose(), (MultiBufferSource)NuggetClientData.bufferSource, 0xF000F0);
        NuggetClientData.bufferSource.endBatch();
    }

    public static void drawCenteredOutlinedText(Font font, GuiGraphics graphics, FormattedCharSequence component, int x, int y) {
        GuiHelpers.drawOutlinedText(font, graphics, component, x - GuiHelpers.halfWidthOfText(font, component), y);
    }

    public static void drawCenteredOutlinedText(Font font, GuiGraphics graphics, Component component, int x, int y) {
        GuiHelpers.drawCenteredOutlinedText(font, graphics, component.getVisualOrderText(), x, y);
    }

    public static boolean isMouseInRelativeRange(double mouseX, double mouseY, AbstractWidget widget) {
        return GuiHelpers.isMouseInRelativeRange((int)mouseX, (int)mouseY, widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
    }

    public static boolean isMouseInRelativeRange(int mouseX, int mouseY, AbstractWidget widget) {
        return GuiHelpers.isMouseInRelativeRange(mouseX, mouseY, widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
    }

    public static boolean isMouseInRelativeRange(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        return GuiHelpers.gatherTooltipComponents(textElements, Optional.empty(), mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static void drawCenteredStringNoShadow(Font font, GuiGraphics graphics, Component component, int x, int y, int color) {
        graphics.drawString(font, component.getString(), x - GuiHelpers.halfWidthOfText(font, component.getVisualOrderText()), y, color, false);
    }

    public static void drawCenteredStringNoShadow(Font font, GuiGraphics graphics, FormattedCharSequence component, int x, int y, int color) {
        graphics.drawString(font, component, x - GuiHelpers.halfWidthOfText(font, component), y, color, false);
    }

    public static int halfWidthOfText(Font font, FormattedCharSequence component) {
        return font.width(component) / 2;
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = fallbackFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        int tooltipTextWidth = elements.stream().mapToInt(either -> {
            Objects.requireNonNull(font);
            return (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0);
        }).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (screenWidth > 0 && tooltipTextWidth > screenWidth) {
            tooltipTextWidth = screenWidth;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return needsWrap ? elements.stream().flatMap(either -> (Stream)either.map(text -> GuiHelpers.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList() : elements.stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.create((FormattedCharSequence)(text instanceof Component ? ((Component)text).getVisualOrderText() : Language.getInstance().getVisualOrder(text))), ClientTooltipComponent::create)).toList();
    }

    public static Stream<ClientTooltipComponent> splitLine(FormattedText text, Font font, int maxWidth) {
        Component component;
        if (text instanceof Component && (component = (Component)text).getString().isEmpty()) {
            return Stream.of(component.getVisualOrderText()).map(ClientTooltipComponent::create);
        }
        return font.split(text, maxWidth).stream().map(ClientTooltipComponent::create);
    }
}

