/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.Constants;
import com.hollingsworth.nuggets.client.area_capture.RenderStructureHandler;
import com.hollingsworth.nuggets.client.area_capture.StructureRenderData;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;

public class PlaceSchematicScreen
extends Screen {
    public final String holdToFocus = "nuggets.gui.toolmenu.focusKey";
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;
    public List<ToolType> tools = new ArrayList<ToolType>();
    public RenderStructureHandler renderStructureHandler;
    public BiFunction<Player, StructureRenderData, List<ToolType>> setupToolsFunc;
    public KeyMapping focusKey;

    public PlaceSchematicScreen(KeyMapping focusKey, RenderStructureHandler renderStructureHandler, StructureRenderData data, BiFunction<Player, StructureRenderData, List<ToolType>> setupToolsFunc) {
        super((Component)Component.literal((String)"Tool Selection"));
        this.focusKey = focusKey;
        this.renderStructureHandler = renderStructureHandler;
        this.minecraft = Minecraft.getInstance();
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        this.h = 34;
        this.tools.add(new PlaceTool(data, this));
        this.setupToolsFunc = setupToolsFunc;
    }

    public void setTools(List<ToolType> tools) {
        this.tools = tools;
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains(tool)) {
            return;
        }
        this.selection = this.tools.indexOf(tool);
    }

    public ToolType getSelectedElement() {
        return this.tools.get(this.selection);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(GuiGraphics graphics, float partialTicks) {
        this.w = Math.max(this.tools.size() * 50 + 32, 220);
        PoseStack matrixStack = graphics.pose();
        Window mainWindow = this.minecraft.getWindow();
        if (!this.initialized) {
            this.init(this.minecraft, mainWindow.getGuiScaledWidth(), mainWindow.getGuiScaledHeight());
        }
        int x = (mainWindow.getGuiScaledWidth() - this.w) / 2 + 14;
        int y = mainWindow.getGuiScaledHeight() - this.h - 34;
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        graphics.blit(Constants.prefix("textures/gui/hud_background.png"), x - 15, y, 0.0f, 0.0f, this.w, this.h, 16, 16);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        if (toolTipAlpha > 0.25f) {
            graphics.blit(Constants.prefix("textures/gui/hud_background.png"), x - 15, y + 16, 0.0f, 0.0f, this.w, this.h, 16, 16);
            if (!toolTip.isEmpty()) {
                GuiHelpers.drawOutlinedText(this.minecraft.font, graphics, toolTip.get(0), x - 10, y + 38);
            }
            if (toolTip.size() > 1) {
                GuiHelpers.drawOutlinedText(this.minecraft.font, graphics, toolTip.get(1), x - 10, y + 50);
            }
        }
        if (this.tools.size() > 1) {
            String keyName = this.focusKey.getTranslatedKeyMessage().getString();
            int width = this.minecraft.getWindow().getGuiScaledWidth();
            if (!this.focused) {
                GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"nuggets.gui.toolmenu.focusKey", (Object[])new Object[]{keyName}), width / 2, y - 10);
            } else {
                GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"nuggets.scroll"), width / 2, y - 10);
            }
        } else {
            GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"nuggets.place_description"), this.width / 2, y - 10);
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            matrixStack.pushPose();
            if (i == this.selection) {
                matrixStack.translate(0.0f, -10.0f, 0.0f);
                GuiHelpers.drawCenteredOutlinedText(this.minecraft.font, graphics, this.tools.get(i).getDisplayName(), x + i * 50 + 26, y + 28);
            }
            ResourceLocation icon = this.tools.get(i).getIcon();
            graphics.blit(icon, x + i * 50 + 16, y + 11, 0.0f, 0.0f, 16, 16, 16, 16);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public boolean scroll(double delta) {
        if (this.focused) {
            this.cycle((int)delta);
            return true;
        }
        if (PlaceSchematicScreen.hasControlDown()) {
            return this.tools.get(this.selection).handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(GuiGraphics graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void onClose() {
    }

    protected void init() {
        super.init();
        this.initialized = true;
    }

    public static class PlaceTool
    extends ToolType {
        public PlaceTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super((Component)Component.translatable((String)"nuggets.place_tool"), Constants.prefix("textures/gui/visualizer_icon_place.png"), structureData, placeSchematicScreen);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            this.structureData.anchorPos = RaycastHelper.getLookingAt(this.structureData.distanceFromCameraCast, (Player)Minecraft.getInstance().player, true).getBlockPos();
            this.placeSchematicScreen.setTools(this.placeSchematicScreen.setupToolsFunc.apply((Player)Minecraft.getInstance().player, this.structureData));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            if (this.structureData == null) {
                return false;
            }
            this.structureData.distanceFromCameraCast = delta > 0.0 ? (this.structureData.distanceFromCameraCast += 1.0) : (this.structureData.distanceFromCameraCast -= 1.0);
            return true;
        }
    }

    public static abstract class ToolType {
        public Component name;
        public ResourceLocation icon;
        public StructureRenderData structureData;
        public PlaceSchematicScreen placeSchematicScreen;

        public ToolType(Component name, ResourceLocation icon, StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            this.name = name;
            this.icon = icon;
            this.structureData = structureData;
            this.placeSchematicScreen = placeSchematicScreen;
        }

        public void onClick() {
        }

        public Component getDisplayName() {
            return this.name;
        }

        abstract List<Component> getDescription();

        public ResourceLocation getIcon() {
            return this.icon;
        }

        public boolean handleMouseWheel(double delta) {
            return false;
        }
    }

    public static class RotateTool
    extends ToolType {
        public RotateTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super((Component)Component.translatable((String)"nuggets.rotate_tool"), Constants.prefix("textures/gui/visualizer_icon_rotate.png"), structureData, placeSchematicScreen);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            if (this.structureData == null) {
                return false;
            }
            this.structureData.rotate(delta > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
            this.structureData.lastRenderPos = null;
            return true;
        }
    }

    public static class PrintTool
    extends ToolType {
        public Consumer<PrintTool> onClickConsumer;

        public PrintTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen, Consumer<PrintTool> onClickConsumer) {
            super((Component)Component.translatable((String)"nuggets.print_tool"), Constants.prefix("textures/gui/visualizer_print.png"), structureData, placeSchematicScreen);
            this.onClickConsumer = onClickConsumer;
        }

        @Override
        public void onClick() {
            this.onClickConsumer.accept(this);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.print_description"));
            return list;
        }
    }

    public static class ConfirmTool
    extends ToolType {
        public Consumer<ConfirmTool> onClickConsumer;

        public ConfirmTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen, Consumer<ConfirmTool> onClickConsumer) {
            super((Component)Component.translatable((String)"nuggets.confirm_tool"), Constants.prefix("textures/gui/visualizer_icon_confirm.png"), structureData, placeSchematicScreen);
            this.onClickConsumer = onClickConsumer;
        }

        @Override
        public void onClick() {
            this.onClickConsumer.accept(this);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.confirm_description"));
            return list;
        }
    }

    public static class MirrorTool
    extends ToolType {
        public MirrorTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super((Component)Component.translatable((String)"nuggets.mirror_tool"), Constants.prefix("textures/gui/visualizer_icon_mirror.png"), structureData, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            this.structureData.flip();
            this.structureData.lastRenderPos = null;
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.mirror_description"));
            return list;
        }
    }

    public static class MoveVerticalTool
    extends ToolType {
        public MoveVerticalTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super((Component)Component.translatable((String)"nuggets.move_vertical_tool"), Constants.prefix("textures/gui/visualizer_icon_vertical.png"), structureData, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            if (this.structureData == null || this.structureData.anchorPos == null) {
                return false;
            }
            this.structureData.anchorPos = this.structureData.anchorPos.offset((Vec3i)new BlockPos(0, (int)delta, 0));
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.move_vertical_description"));
            return list;
        }
    }

    public static class MoveHorizontalTool
    extends ToolType {
        public MoveHorizontalTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super((Component)Component.translatable((String)"nuggets.move_horizontal_tool"), Constants.prefix("textures/gui/visualizer_icon_horizontal.png"), structureData, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Direction direction = Minecraft.getInstance().player.getNearestViewDirection();
            BlockPos offset = new BlockPos((int)delta * direction.getStepX(), 0, (int)delta * direction.getStepZ());
            this.structureData.anchorPos = this.structureData.anchorPos.offset((Vec3i)offset);
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.move_horizontal_description"));
            return list;
        }
    }

    public static class DeleteTool
    extends ToolType {
        public Consumer<DeleteTool> onClickConsumer;

        public DeleteTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen, Consumer<DeleteTool> onClickConsumer) {
            super((Component)Component.translatable((String)"nuggets.delete_tool"), Constants.prefix("textures/gui/visualizer_trash.png"), structureData, placeSchematicScreen);
            this.onClickConsumer = onClickConsumer;
        }

        @Override
        public void onClick() {
            this.onClickConsumer.accept(this);
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"nuggets.delete_description"));
            return list;
        }
    }
}

