/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import com.hollingsworth.nuggets.common.util.VecHelper;
import com.hollingsworth.nuggets.common.util.WorldHelpers;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AreaCaptureHandler {
    public BlockPos firstTarget;
    public BlockPos secondTarget;
    public boolean showBoundary;
    public Direction selectedFace = null;
    public BiConsumer<GuiGraphics, Window> onRender;
    Consumer<StructureTemplate> onConfirmedStructure;
    public BlockPos selectedPos = null;

    public AreaCaptureHandler(BiConsumer<GuiGraphics, Window> onRender, Consumer<StructureTemplate> onConfirmedStructure) {
        this.onRender = onRender;
        this.onConfirmedStructure = onConfirmedStructure;
    }

    public void startCapture() {
        this.showBoundary = true;
        this.firstTarget = null;
        this.secondTarget = null;
    }

    public void cancelCapture() {
        this.showBoundary = false;
        this.firstTarget = null;
        this.secondTarget = null;
    }

    public void onConfirmHit() {
        if (!this.showBoundary) {
            return;
        }
        this.showBoundary = false;
        if (this.firstTarget != null && this.secondTarget != null) {
            StructureTemplate structure = WorldHelpers.getStructure((Level)Minecraft.getInstance().level, this.firstTarget, this.secondTarget);
            this.onConfirmedStructure.accept(structure);
        }
    }

    public void onCancelHit() {
        if (!this.showBoundary) {
            return;
        }
        this.cancelCapture();
    }

    public void renderBoundary(PoseStack poseStack, Matrix4f modelViewMatrix) {
        if (!this.showBoundary) {
            return;
        }
        BlockPos firstPos = this.firstTarget;
        LocalPlayer player = Minecraft.getInstance().player;
        BlockHitResult trace = RaycastHelper.rayTraceRange(player.level(), (Player)player, 75.0);
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockPos hit = trace.getBlockPos();
            boolean replaceable = player.level().getBlockState(hit).canBeReplaced(new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, trace)));
            if (trace.getDirection().getAxis().isVertical() && !replaceable) {
                hit = hit.relative(trace.getDirection());
            }
            this.selectedPos = hit;
        } else {
            this.selectedPos = null;
        }
        if (firstPos == null && this.selectedPos != null) {
            this.renderBbox(new AABB(this.selectedPos), poseStack, modelViewMatrix);
            return;
        }
        BlockPos secondPos = this.secondTarget;
        if (secondPos == null) {
            secondPos = this.selectedPos;
        }
        AABB currentSelectionBox = null;
        currentSelectionBox = secondPos == null ? (firstPos == null ? (this.selectedPos == null ? null : new AABB(this.selectedPos)) : (this.selectedPos == null ? new AABB(firstPos) : AABB.encapsulatingFullBlocks((BlockPos)firstPos, (BlockPos)this.selectedPos).expandTowards(1.0, 1.0, 1.0))) : AABB.encapsulatingFullBlocks((BlockPos)firstPos, (BlockPos)secondPos).expandTowards(1.0, 1.0, 1.0);
        this.renderBbox(currentSelectionBox, poseStack, modelViewMatrix);
    }

    public void renderBbox(AABB currentSelectionBox, PoseStack poseStack, Matrix4f modelViewMatrix) {
        if (currentSelectionBox == null) {
            return;
        }
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        currentSelectionBox.move(camera.scale(-1.0));
        currentSelectionBox = currentSelectionBox.move(-camera.x, -camera.y, -camera.z);
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        VertexConsumer vertexconsumer = NuggetClientData.bufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (AABB)currentSelectionBox, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        NuggetClientData.bufferSource.endBatch();
        poseStack.popPose();
    }

    public boolean positionClicked() {
        if (!this.showBoundary) {
            return false;
        }
        BlockPos pos = this.selectedPos;
        if (pos == null) {
            return false;
        }
        if (this.firstTarget == null) {
            this.firstTarget = pos.immutable();
            return true;
        }
        if (this.secondTarget == null && !this.firstTarget.equals((Object)pos)) {
            this.secondTarget = pos.immutable();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double delta) {
        if (!this.showBoundary || this.firstTarget == null || this.secondTarget == null) {
            return false;
        }
        if (!Screen.hasControlDown()) {
            return false;
        }
        if (this.selectedFace == null) {
            return true;
        }
        AABB bb = new AABB((double)this.firstTarget.getX(), (double)this.firstTarget.getY(), (double)this.firstTarget.getZ(), (double)this.secondTarget.getX(), (double)this.secondTarget.getY(), (double)this.secondTarget.getZ());
        Vec3i vec = this.selectedFace.getNormal();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        if (bb.contains(projectedView)) {
            delta *= -1.0;
        }
        int x = (int)((double)vec.getX() * delta);
        int y = (int)((double)vec.getY() * delta);
        int z = (int)((double)vec.getZ() * delta);
        Direction.AxisDirection axisDirection = this.selectedFace.getAxisDirection();
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            bb = bb.move((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.maxX - (double)(x * axisDirection.getStep()), bb.minX);
        double maxY = Math.max(bb.maxY - (double)(y * axisDirection.getStep()), bb.minY);
        double maxZ = Math.max(bb.maxZ - (double)(z * axisDirection.getStep()), bb.minZ);
        bb = new AABB(bb.minX, bb.minY, bb.minZ, maxX, maxY, maxZ);
        this.firstTarget = BlockPos.containing((double)bb.minX, (double)bb.minY, (double)bb.minZ);
        this.secondTarget = BlockPos.containing((double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        LocalPlayer player = Minecraft.getInstance().player;
        player.displayClientMessage((Component)Component.translatable((String)"blockprints.dimensions", (Object[])new Object[]{(int)bb.getXsize() + 1, (int)bb.getYsize() + 1, (int)bb.getZsize() + 1}), true);
        return true;
    }

    public void tick() {
        this.selectedFace = null;
        if (this.secondTarget != null) {
            Vec3 projectedView;
            LocalPlayer player = Minecraft.getInstance().player;
            AABB bb = AABB.encapsulatingFullBlocks((BlockPos)this.firstTarget, (BlockPos)this.secondTarget).expandTowards(1.0, 1.0, 1.0).inflate((double)0.45f);
            boolean inside = bb.contains(projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((Player)player, 70.0, pos -> inside ^ bb.contains(VecHelper.getCenterOf((Vec3i)pos)));
            this.selectedFace = result.missed() ? null : (inside ? result.getFacing().getOpposite() : result.getFacing());
        }
    }

    public void renderBoundaryUI(GuiGraphics graphics, Window window) {
        if (!this.showBoundary || Minecraft.getInstance().options.hideGui) {
            return;
        }
        this.onRender.accept(graphics, window);
    }
}

