/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.BaseSchematicScreen;
import com.hollingsworth.nuggets.client.area_capture.RenderStructureHandler;
import com.hollingsworth.nuggets.client.area_capture.StructureRenderData;
import com.hollingsworth.nuggets.client.area_capture.ToolType;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;

public class PlaceSchematicScreen
extends BaseSchematicScreen {
    public RenderStructureHandler renderStructureHandler;
    public PlaceTool placeTool;
    public RotateTool rotateTool;
    public MoveHorizontalTool moveHorizontalTool;
    public MoveVerticalTool moveVerticalTool;
    public ConfirmTool confirmTool;
    public PrintTool printTool;
    public DeleteTool deleteTool;
    public MirrorTool mirrorTool;

    public PlaceSchematicScreen(String modId, class_304 focusKey, RenderStructureHandler<?> renderStructureHandler) {
        super(modId, focusKey, (class_2561)class_2561.method_43470((String)"Tool Selection"));
        this.renderStructureHandler = renderStructureHandler;
        this.placeTool = new PlaceTool(() -> renderStructureHandler.placingData, this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_place.png"));
        this.rotateTool = new RotateTool(() -> renderStructureHandler.placingData, this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_rotate.png"));
        this.moveHorizontalTool = new MoveHorizontalTool(() -> renderStructureHandler.placingData, this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_horizontal.png"));
        this.moveVerticalTool = new MoveVerticalTool(() -> renderStructureHandler.placingData, this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_vertical.png"));
        this.confirmTool = new ConfirmTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_confirm.png"));
        this.printTool = new PrintTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_print.png"));
        this.deleteTool = new DeleteTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_trash.png"));
        this.mirrorTool = new MirrorTool(() -> renderStructureHandler.placingData, this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_mirror.png"));
        this.tools.add(this.placeTool);
    }

    public void setupManipulationTools() {
        this.tools.clear();
        this.tools.add(this.moveHorizontalTool);
        this.tools.add(this.moveVerticalTool);
        this.tools.add(this.rotateTool);
        this.tools.add(this.confirmTool);
        if (this.renderStructureHandler.onPrint != null) {
            this.tools.add(this.printTool);
        }
        this.tools.add(this.deleteTool);
    }

    public static class PlaceTool
    extends ToolType<PlaceSchematicScreen> {
        public Supplier<StructureRenderData> getStructure;

        public PlaceTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.place_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            StructureRenderData structureData = this.getStructure.get();
            structureData.anchorPos = RaycastHelper.getLookingAt(structureData.distanceFromCameraCast, (class_1657)class_310.method_1551().field_1724, true).method_17777();
            ((PlaceSchematicScreen)this.placeSchematicScreen).setupManipulationTools();
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            if (structureData == null) {
                return false;
            }
            structureData.distanceFromCameraCast = delta > 0.0 ? (structureData.distanceFromCameraCast += 1.0) : (structureData.distanceFromCameraCast -= 1.0);
            return true;
        }
    }

    public static class RotateTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public RotateTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.rotate_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            if (structureData == null) {
                return false;
            }
            structureData.rotate(delta > 0.0 ? class_2470.field_11463 : class_2470.field_11465);
            structureData.lastRenderPos = null;
            return true;
        }
    }

    public static class MoveHorizontalTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public MoveHorizontalTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.move_horizontal_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            class_2350 direction = class_310.method_1551().field_1724.method_58149();
            class_2338 offset = new class_2338((int)delta * direction.method_10148(), 0, (int)delta * direction.method_10165());
            structureData.anchorPos = structureData.anchorPos.method_10081((class_2382)offset);
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public MoveVerticalTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.move_vertical_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            if (structureData == null || structureData.anchorPos == null) {
                return false;
            }
            structureData.anchorPos = structureData.anchorPos.method_10081((class_2382)new class_2338(0, (int)delta, 0));
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.move_vertical_description"));
            return list;
        }
    }

    public static class ConfirmTool
    extends ToolType<PlaceSchematicScreen> {
        public ConfirmTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.confirm_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            ((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler.onConfirm.accept(((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.confirm_description"));
            return list;
        }
    }

    public static class PrintTool
    extends ToolType<PlaceSchematicScreen> {
        public PrintTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.print_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            ((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler.onPrint.accept(((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.print_description"));
            return list;
        }
    }

    public static class DeleteTool
    extends ToolType<PlaceSchematicScreen> {
        public DeleteTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.delete_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            ((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler.onDelete.accept(((PlaceSchematicScreen)this.placeSchematicScreen).renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.delete_description"));
            return list;
        }
    }

    public static class MirrorTool
    extends ToolType {
        Supplier<StructureRenderData> getStructure;

        public MirrorTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.mirror_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = this.getStructure.get();
            structureData.flip();
            structureData.lastRenderPos = null;
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.mirror_description"));
            return list;
        }
    }
}

