package com.hollingsworth.nuggets.datagen.patchouli;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;

public class RelationsPage extends AbstractPage {

    List<String> entries = new ArrayList<>();

    public RelationsPage() {
    }

    public RelationsPage withEntry(class_2960 category, String fileName) {
        return withEntry(category.toString() + "/" + fileName);
    }

    public RelationsPage withEntry(String path){
        entries.add(path);
        return this;
    }

    public RelationsPage withEntry(PatchouliRecord page) {
        return withEntry(page.relationPath());
    }

    public RelationsPage withEntries(List<PatchouliRecord> pages) {
        for(PatchouliRecord page : pages)
            withEntry(page);
        return this;
    }


    public RelationsPage withTitle(String title) {
        object.addProperty("title", title);
        return this;
    }

    public RelationsPage withText(String text) {
        object.addProperty("text", text);
        return this;
    }

    @Override
    public JsonObject build() {
        JsonArray array = new JsonArray();
        for (String s : entries)
            array.add(s);
        object.add("entries", array);
        return super.build();
    }

    @Override
    public class_2960 getType() {
        return class_2960.method_12829("patchouli:relations");
    }
}
