package com.hollingsworth.nuggets.datagen;

import com.hollingsworth.nuggets.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.nuggets.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.nuggets.datagen.patchouli.PatchouliRecord;
import com.hollingsworth.nuggets.datagen.patchouli.TextPage;
import com.hollingsworth.nuggets.common.registry.RegistryHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import net.minecraft.class_7403;



public abstract class PatchouliProvider extends SimpleDataProvider{
    public List<PatchouliRecord> pages = new ArrayList<>();
    public String modId;
    public String bookName;

    public PatchouliProvider(String modId, String bookName, class_2403 generatorIn, Path outputPath) {
        super(generatorIn, outputPath);
        this.modId = modId;
    }

    public abstract void addEntries(List<PatchouliRecord> pages);

    public String getLangPath(String name, int count) {
        return modId + ".page" + count + "." + name;
    }

    public String getLangPath(String name) {
        return modId + ".page." + name;
    }

    public PatchouliRecord addPage(PatchouliBuilder builder, Path path) {
        return addPage(new PatchouliRecord(builder, path));
    }

    public PatchouliRecord addPage(PatchouliRecord patchouliPage){
        this.pages.add(patchouliPage);
        return patchouliPage;
    }

    public PatchouliBuilder buildBasicItem(class_1935 item, class_2960 category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.method_8389().method_7876())
                .withIcon(item.method_8389())
                .withPage(new TextPage("ars_nouveau.page." + RegistryHelper.getRegistryName(item.method_8389()).method_12832()));
        if (recipePage != null) {
            builder.withPage(recipePage);
        }
        return builder;
    }

    public PatchouliRecord addBasicItem(class_1935 item, class_2960 category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = buildBasicItem(item, category, recipePage);
        return addPage(new PatchouliRecord(builder, getPath(category, RegistryHelper.getRegistryName(item.method_8389()))));
    }

    public Path getPath(class_2960 category, class_2960 fileName) {
        return this.output.resolve("assets/" + modId + "/patchouli_books/" + bookName + "/en_us/entries/" + category.method_12832() + "/" + fileName.method_12832() + ".json");
    }

    public Path getPath(class_2960 category, String fileName) {
        return this.output.resolve("assets/" + modId + "/patchouli_books/" + bookName + "/en_us/entries/" + category.method_12832() + "/" + fileName + ".json");
    }

    @Override
    public void collectJsons(class_7403 pOutput) {
        addEntries(this.pages);
        for (PatchouliRecord patchouliPage : pages) {
            saveStable(pOutput, patchouliPage.build(), patchouliPage.path());
        }
    }

    @Override
    public String method_10321() {
        return "Patchouli";
    }
}
