package com.hollingsworth.nuggets.datagen;

import com.google.common.collect.Maps;
import net.minecraft.advancements.*;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import javax.annotation.Nullable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * Copied from Advancements.Builder with extensions to reduce copy pasta
 */
public class DataAdvancementBuilder {
    @Nullable
    private class_2960 parentId;
    @Nullable
    private class_8779 parent;
    @Nullable
    private class_185 display;
    private class_170 rewards = class_170.field_1167;
    private Map<String, class_175<?>> criteria = Maps.newLinkedHashMap();
    @Nullable
    private class_8782 requirements;
    private class_8782.class_8797 requirementsStrategy = class_8782.class_8797.field_16882;
    private String modid;
    private String fileKey;

    private DataAdvancementBuilder(@Nullable class_2960 pParentId, @Nullable class_185 pDisplay, class_170 pRewards, Map<String, class_175<?>> pCriteria, class_8782 pRequirements) {
        this.parentId = pParentId;
        this.display = pDisplay;
        this.rewards = pRewards;
        this.criteria = pCriteria;
        this.requirements = pRequirements;
    }

    private DataAdvancementBuilder(String modid, String fileKey) {
        this.modid = modid;
        this.fileKey = fileKey;
    }

    public static DataAdvancementBuilder builder(String modid, String fileKey) {
        return new DataAdvancementBuilder(modid, fileKey);
    }

    public DataAdvancementBuilder parent(class_8779 parent) {
        this.parent = parent;
        return this.parent(parent.comp_1919());
    }

    public DataAdvancementBuilder parent(class_2960 pParentId) {
        this.parentId = pParentId;
        return this;
    }

    public DataAdvancementBuilder display(class_1799 pStack, class_2561 pTitle, class_2561 pDescription, @Nullable class_2960 pBackground, class_189 pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
        return this.display(new class_185(pStack, pTitle, pDescription, Optional.ofNullable(pBackground), pFrame, pShowToast, pAnnounceToChat, pHidden));
    }

    public DataAdvancementBuilder display(class_1935 pItem, class_2561 pTitle, class_2561 pDescription, @Nullable class_2960 pBackground, class_189 pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
        return this.display(new class_185(new class_1799(pItem.method_8389()), pTitle, pDescription, Optional.ofNullable(pBackground), pFrame, pShowToast, pAnnounceToChat, pHidden));
    }

    public DataAdvancementBuilder display(class_185 pDisplay) {
        this.display = pDisplay;
        return this;
    }

    // The following displays cannot be used for roots.
    public DataAdvancementBuilder display(class_1799 pItem, class_189 pFrame) {
        return this.display(new class_185(pItem, this.getComponent("title"), this.getComponent("desc"), Optional.empty(), pFrame, true, true, false));
    }

    public DataAdvancementBuilder display(class_1935 pItem, class_189 pFrame) {
        return this.display(new class_1799(pItem), pFrame);
    }

    // The following displays cannot be used for roots.
    public DataAdvancementBuilder display(class_1799 pItem, class_189 pFrame, boolean hidden) {
        return this.display(new class_185(pItem, this.getComponent("title"), this.getComponent("desc"), Optional.empty(), pFrame, true, true, hidden));
    }

    public DataAdvancementBuilder display(class_1935 pItem, class_189 pFrame, boolean hidden) {
        return this.display(new class_1799(pItem), pFrame, hidden);
    }


    public DataAdvancementBuilder rewards(class_170.class_171 pRewardsBuilder) {
        return this.rewards(pRewardsBuilder.method_751());
    }

    public DataAdvancementBuilder rewards(class_170 pRewards) {
        this.rewards = pRewards;
        return this;
    }

    public DataAdvancementBuilder addCriterion(class_175<?> pCriterion) {
        return this.addCriterion(fileKey, pCriterion);
    }

    public DataAdvancementBuilder addCriterion(String pKey, class_175<?> pCriterion) {
        if (this.criteria.containsKey(pKey)) {
            throw new IllegalArgumentException("Duplicate criterion " + pKey);
        } else {
            this.criteria.put(pKey, pCriterion);
            return this;
        }
    }

    public DataAdvancementBuilder requirements(class_8782.class_8797 pStrategy) {
        this.requirementsStrategy = pStrategy;
        return this;
    }

    public DataAdvancementBuilder requirements(class_8782 pRequirements) {
        this.requirements = pRequirements;
        return this;
    }

    public DataAdvancementBuilder normalItemRequirement(class_1935 item) {
        return this.display(item, class_189.field_1254).requireItem(item);
    }

    public DataAdvancementBuilder requireItem(class_1935 item) {
        return this.addCriterion("has_" + class_7923.field_41178.method_10221(item.method_8389()).method_12832(), class_2066.class_2068.method_8959(item));
    }

    public class_5250 getComponent(String type) {
        return class_2561.method_43471(modid + ".adv." + type + "." + fileKey);
    }

    public class_161 build() {

        if (this.requirements == null) {
            this.requirements = this.requirementsStrategy.create(this.criteria.keySet());
        }
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Advancement " + fileKey + " has no criteria " + this);
        }
        return new class_161(Optional.ofNullable(this.parentId), Optional.ofNullable(this.display), this.rewards, this.criteria, this.requirements, false);
    }

    public class_8779 save(Consumer<class_8779> pConsumer, class_2960 pId) {
        var adv =  this.build();
        class_8779 advancement = new class_8779(pId, adv);
        pConsumer.accept(advancement);
        return advancement;
    }

    public class_8779 save(Consumer<class_8779> pConsumer, String namespace) {
        return this.save(pConsumer, class_2960.method_60655(namespace, fileKey));
    }

    public String toString() {
        return "Task Advancement{parentId=" + this.parentId + ", display=" + this.display + ", rewards=" + this.rewards + ", criteria=" + this.criteria + ", requirements=" + this.requirements + "}";
    }

    public Map<String, class_175<?>> getCriteria() {
        return this.criteria;
    }
}

