package com.hollingsworth.nuggets.common.debug;

import com.hollingsworth.nuggets.mixin.MobAccessor;
import java.io.PrintWriter;
import net.minecraft.class_1297;
import net.minecraft.class_4135;

public class EntityDebugger implements IDebugger{
    public FixedStack<EntityEvent> events;

    public final class_1297 entity;

    public EntityDebugger(class_1297 entity) {
        this(entity, 100);
    }

    public EntityDebugger(class_1297 entity, int size) {
        this.entity = entity;
        events = new FixedStack<>(size);
    }

    @Override
    public void addEntityEvent(DebugEvent event, boolean storeDuplicate) {
        // Do not store duplicate events back to back with the same ID
        if(storeDuplicate || events.isEmpty() || !events.peek().id.equals(event.id)){
            events.push(new EntityEvent(entity, event.id, event.message));
        }
    }

    @Override
    public void writeFile(PrintWriter writer) {
        writer.print("Entity: " + " (" + entity.getClass().getSimpleName() + ")");
        // print current entity goal
        if(entity instanceof MobAccessor mob){
            for(class_4135 goal : mob.getGoalSelector().method_35115().stream().filter(class_4135::method_19056).toList()){
                writer.println("Running Goal: " + goal.method_19058().getClass().getSimpleName());
            }
        }
        for(EntityEvent event : events){
            writer.println(event.toString());
        }
    }
}
